/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.javadsl;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.generate.SwaggerTestGenerator;
import org.citrusframework.generate.TestGenerator;
import org.citrusframework.generate.javadsl.MessagingJavaTestGenerator;
import org.citrusframework.http.actions.HttpActionBuilder;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.Message;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.variable.dictionary.json.JsonPathMappingDataDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

public class SwaggerJavaTestGenerator
extends MessagingJavaTestGenerator<SwaggerJavaTestGenerator>
implements SwaggerTestGenerator<SwaggerJavaTestGenerator> {
    private static final Logger logger = LoggerFactory.getLogger(SwaggerJavaTestGenerator.class);
    private String swaggerResource;
    private String contextPath;
    private String operation;
    private String namePrefix;
    private String nameSuffix = "_IT";
    private final JsonPathMappingDataDictionary inboundDataDictionary = new JsonPathMappingDataDictionary();
    private final JsonPathMappingDataDictionary outboundDataDictionary = new JsonPathMappingDataDictionary();

    @Override
    protected JavaFile.Builder createJavaFileBuilder(TypeSpec.Builder testTypeBuilder) {
        return super.createJavaFileBuilder(testTypeBuilder).addStaticImport(HttpActionBuilder.class, new String[]{"http"});
    }

    @Override
    public void create() {
        Swagger swagger;
        try {
            swagger = new SwaggerParser().parse(FileUtils.readToString((Resource)Resources.create((String)this.swaggerResource)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to parse Swagger Open API specification: " + this.swaggerResource, (Throwable)e);
        }
        if (!StringUtils.hasText((String)this.namePrefix)) {
            this.withNamePrefix(Optional.ofNullable(swagger.getInfo().getTitle()).orElse("Swagger").replaceAll("\\s", "") + "_");
        }
        for (Map.Entry path : swagger.getPaths().entrySet()) {
            for (Map.Entry operation : ((Path)path.getValue()).getOperationMap().entrySet()) {
                this.withName(this.namePrefix + ((Operation)operation.getValue()).getOperationId() + this.nameSuffix);
                HttpMessage requestMessage = new HttpMessage();
                if (this.getMode().equals((Object)TestGenerator.GeneratorMode.CLIENT)) {
                    String randomizedPath = (String)path.getKey();
                    if (((Operation)operation.getValue()).getParameters() != null) {
                        List pathParams = ((Operation)operation.getValue()).getParameters().stream().filter(p -> p instanceof PathParameter).map(PathParameter.class::cast).collect(Collectors.toList());
                        for (PathParameter pathParameter : pathParams) {
                            randomizedPath = randomizedPath.replaceAll("\\{" + pathParameter.getName() + "\\}", this.createRandomValueExpression((AbstractSerializableParameter)pathParameter));
                        }
                    }
                    requestMessage.path(Optional.ofNullable(this.contextPath).orElse("") + Optional.ofNullable(swagger.getBasePath()).filter(basePath -> !basePath.equals("/")).orElse("") + randomizedPath);
                } else {
                    requestMessage.path("@assertThat(matchesPath(" + (String)path.getKey() + "))@");
                }
                requestMessage.method(HttpMethod.valueOf((String)((io.swagger.models.HttpMethod)operation.getKey()).name()));
                if (((Operation)operation.getValue()).getParameters() != null) {
                    ((Operation)operation.getValue()).getParameters().stream().filter(p -> p instanceof HeaderParameter).filter(Parameter::getRequired).forEach(p -> requestMessage.setHeader(p.getName(), (Object)(this.getMode().equals((Object)TestGenerator.GeneratorMode.CLIENT) ? this.createRandomValueExpression(((HeaderParameter)p).getItems(), swagger.getDefinitions(), false) : this.createValidationExpression(((HeaderParameter)p).getItems(), swagger.getDefinitions(), false))));
                    ((Operation)operation.getValue()).getParameters().stream().filter(param -> param instanceof QueryParameter).filter(Parameter::getRequired).forEach(param -> requestMessage.queryParam(param.getName(), this.getMode().equals((Object)TestGenerator.GeneratorMode.CLIENT) ? this.createRandomValueExpression((AbstractSerializableParameter)((QueryParameter)param)) : this.createValidationExpression((AbstractSerializableParameter)((QueryParameter)param))));
                    ((Operation)operation.getValue()).getParameters().stream().filter(p -> p instanceof BodyParameter).filter(Parameter::getRequired).findFirst().ifPresent(p -> requestMessage.setPayload((Object)(this.getMode().equals((Object)TestGenerator.GeneratorMode.CLIENT) ? this.createOutboundPayload(((BodyParameter)p).getSchema(), (Map<String, Model>)swagger.getDefinitions()) : this.createInboundPayload(((BodyParameter)p).getSchema(), (Map<String, Model>)swagger.getDefinitions()))));
                }
                this.withRequest((Message)requestMessage);
                HttpMessage responseMessage = new HttpMessage();
                if (((Operation)operation.getValue()).getResponses() != null) {
                    Response response = (Response)((Operation)operation.getValue()).getResponses().get("200");
                    if (response == null) {
                        response = (Response)((Operation)operation.getValue()).getResponses().get("default");
                    }
                    if (response != null) {
                        responseMessage.status((HttpStatusCode)HttpStatus.OK);
                        if (response.getHeaders() != null) {
                            for (Map.Entry entry : response.getHeaders().entrySet()) {
                                responseMessage.setHeader((String)entry.getKey(), (Object)(this.getMode().equals((Object)TestGenerator.GeneratorMode.CLIENT) ? this.createValidationExpression((Property)entry.getValue(), swagger.getDefinitions(), false) : this.createRandomValueExpression((Property)entry.getValue(), swagger.getDefinitions(), false)));
                            }
                        }
                        if (response.getSchema() != null) {
                            responseMessage.setPayload((Object)(this.getMode().equals((Object)TestGenerator.GeneratorMode.CLIENT) ? this.createInboundPayload(response.getSchema(), (Map<String, Model>)swagger.getDefinitions()) : this.createOutboundPayload(response.getSchema(), (Map<String, Model>)swagger.getDefinitions())));
                        }
                    }
                }
                this.withResponse((Message)responseMessage);
                super.create();
                logger.info("Successfully created new test case " + this.getTargetPackage() + "." + this.getName());
            }
        }
    }

    private String createOutboundPayload(Model model, Map<String, Model> definitions) {
        StringBuilder payload = new StringBuilder();
        if (model instanceof RefModel) {
            model = definitions.get(((RefModel)model).getSimpleRef());
        }
        if (model instanceof ArrayModel) {
            payload.append(this.createOutboundPayload(((ArrayModel)model).getItems(), definitions));
        } else {
            payload.append("{");
            if (model.getProperties() != null) {
                for (Map.Entry entry : model.getProperties().entrySet()) {
                    payload.append("\"").append((String)entry.getKey()).append("\": ").append(this.createOutboundPayload((Property)entry.getValue(), definitions)).append(",");
                }
            }
            if (payload.toString().endsWith(",")) {
                payload.replace(payload.length() - 1, payload.length(), "");
            }
            payload.append("}");
        }
        return payload.toString();
    }

    private String createOutboundPayload(Property property, Map<String, Model> definitions) {
        StringBuilder payload = new StringBuilder();
        if (property instanceof RefProperty) {
            Model model = definitions.get(((RefProperty)property).getSimpleRef());
            payload.append("{");
            if (model.getProperties() != null) {
                for (Map.Entry entry : model.getProperties().entrySet()) {
                    payload.append("\"").append((String)entry.getKey()).append("\": ").append(this.createRandomValueExpression((Property)entry.getValue(), definitions, true)).append(",");
                }
            }
            if (payload.toString().endsWith(",")) {
                payload.replace(payload.length() - 1, payload.length(), "");
            }
            payload.append("}");
        } else if (property instanceof ArrayProperty) {
            payload.append("[");
            payload.append(this.createRandomValueExpression(((ArrayProperty)property).getItems(), definitions, true));
            payload.append("]");
        } else {
            payload.append(this.createRandomValueExpression(property, definitions, true));
        }
        return payload.toString();
    }

    private String createRandomValueExpression(Property property, Map<String, Model> definitions, boolean quotes) {
        StringBuilder payload = new StringBuilder();
        if (property instanceof RefProperty) {
            payload.append(this.createOutboundPayload(property, definitions));
        } else if (property instanceof ArrayProperty) {
            payload.append(this.createOutboundPayload(property, definitions));
        } else if (property instanceof StringProperty || property instanceof DateProperty || property instanceof DateTimeProperty) {
            if (quotes) {
                payload.append("\"");
            }
            if (property instanceof DateProperty) {
                payload.append("citrus:currentDate()");
            } else if (property instanceof DateTimeProperty) {
                payload.append("citrus:currentDate('yyyy-MM-dd'T'hh:mm:ss')");
            } else if (((StringProperty)property).getEnum() != null && !((StringProperty)property).getEnum().isEmpty()) {
                payload.append("citrus:randomEnumValue(").append(((StringProperty)property).getEnum().stream().map(value -> "'" + value + "'").collect(Collectors.joining(","))).append(")");
            } else if (Optional.ofNullable(property.getFormat()).orElse("").equalsIgnoreCase("uuid")) {
                payload.append("citrus:randomUUID()");
            } else {
                payload.append("citrus:randomString(").append(((StringProperty)property).getMaxLength() != null && ((StringProperty)property).getMaxLength() > 0 ? ((StringProperty)property).getMaxLength() : (((StringProperty)property).getMinLength() != null && ((StringProperty)property).getMinLength() > 0 ? ((StringProperty)property).getMinLength() : 10)).append(")");
            }
            if (quotes) {
                payload.append("\"");
            }
        } else if (property instanceof IntegerProperty || property instanceof LongProperty) {
            payload.append("citrus:randomNumber(10)");
        } else if (property instanceof FloatProperty || property instanceof DoubleProperty) {
            payload.append("citrus:randomNumber(10)");
        } else if (property instanceof BooleanProperty) {
            payload.append("citrus:randomEnumValue('true', 'false')");
        } else if (quotes) {
            payload.append("\"\"");
        } else {
            payload.append("");
        }
        return payload.toString();
    }

    private String createInboundPayload(Property property, Map<String, Model> definitions) {
        StringBuilder payload = new StringBuilder();
        if (property instanceof RefProperty) {
            Model model = definitions.get(((RefProperty)property).getSimpleRef());
            payload.append("{");
            if (model.getProperties() != null) {
                for (Map.Entry entry : model.getProperties().entrySet()) {
                    payload.append("\"").append((String)entry.getKey()).append("\": ").append(this.createValidationExpression((Property)entry.getValue(), definitions, true)).append(",");
                }
            }
            if (payload.toString().endsWith(",")) {
                payload.replace(payload.length() - 1, payload.length(), "");
            }
            payload.append("}");
        } else if (property instanceof ArrayProperty) {
            payload.append("[");
            payload.append(this.createValidationExpression(((ArrayProperty)property).getItems(), definitions, true));
            payload.append("]");
        } else {
            payload.append(this.createValidationExpression(property, definitions, false));
        }
        return payload.toString();
    }

    private String createInboundPayload(Model model, Map<String, Model> definitions) {
        StringBuilder payload = new StringBuilder();
        if (model instanceof RefModel) {
            model = definitions.get(((RefModel)model).getSimpleRef());
        }
        if (model instanceof ArrayModel) {
            payload.append("[");
            payload.append(this.createValidationExpression(((ArrayModel)model).getItems(), definitions, true));
            payload.append("]");
        } else {
            payload.append("{");
            if (model.getProperties() != null) {
                for (Map.Entry entry : model.getProperties().entrySet()) {
                    payload.append("\"").append((String)entry.getKey()).append("\": ").append(this.createValidationExpression((Property)entry.getValue(), definitions, true)).append(",");
                }
            }
            if (payload.toString().endsWith(",")) {
                payload.replace(payload.length() - 1, payload.length(), "");
            }
            payload.append("}");
        }
        return payload.toString();
    }

    private String createValidationExpression(Property property, Map<String, Model> definitions, boolean quotes) {
        StringBuilder payload = new StringBuilder();
        if (property instanceof RefProperty) {
            Model model = definitions.get(((RefProperty)property).getSimpleRef());
            payload.append("{");
            if (model.getProperties() != null) {
                for (Map.Entry entry : model.getProperties().entrySet()) {
                    payload.append("\"").append((String)entry.getKey()).append("\": ").append(this.createValidationExpression((Property)entry.getValue(), definitions, quotes)).append(",");
                }
            }
            if (payload.toString().endsWith(",")) {
                payload.replace(payload.length() - 1, payload.length(), "");
            }
            payload.append("}");
        } else if (property instanceof ArrayProperty) {
            if (quotes) {
                payload.append("\"");
            }
            payload.append("@ignore@");
            if (quotes) {
                payload.append("\"");
            }
        } else if (property instanceof StringProperty) {
            if (quotes) {
                payload.append("\"");
            }
            if (StringUtils.hasText((String)((StringProperty)property).getPattern())) {
                payload.append("@matches(").append(((StringProperty)property).getPattern()).append(")@");
            } else if (((StringProperty)property).getEnum() != null && !((StringProperty)property).getEnum().isEmpty()) {
                payload.append("@matches(").append(((StringProperty)property).getEnum().stream().collect(Collectors.joining("|"))).append(")@");
            } else {
                payload.append("@notEmpty()@");
            }
            if (quotes) {
                payload.append("\"");
            }
        } else if (property instanceof DateProperty) {
            if (quotes) {
                payload.append("\"");
            }
            payload.append("@matchesDatePattern('yyyy-MM-dd')@");
            if (quotes) {
                payload.append("\"");
            }
        } else if (property instanceof DateTimeProperty) {
            if (quotes) {
                payload.append("\"");
            }
            payload.append("@matchesDatePattern('yyyy-MM-dd'T'hh:mm:ss')@");
            if (quotes) {
                payload.append("\"");
            }
        } else if (property instanceof IntegerProperty || property instanceof LongProperty) {
            if (quotes) {
                payload.append("\"");
            }
            payload.append("@isNumber()@");
            if (quotes) {
                payload.append("\"");
            }
        } else if (property instanceof FloatProperty || property instanceof DoubleProperty) {
            if (quotes) {
                payload.append("\"");
            }
            payload.append("@isNumber()@");
            if (quotes) {
                payload.append("\"");
            }
        } else if (property instanceof BooleanProperty) {
            if (quotes) {
                payload.append("\"");
            }
            payload.append("@matches(true|false)@");
            if (quotes) {
                payload.append("\"");
            }
        } else {
            if (quotes) {
                payload.append("\"");
            }
            payload.append("@ignore@");
            if (quotes) {
                payload.append("\"");
            }
        }
        return payload.toString();
    }

    private String createValidationExpression(AbstractSerializableParameter parameter) {
        switch (parameter.getType()) {
            case "integer": {
                return "@isNumber()@";
            }
            case "string": {
                if (parameter.getFormat() != null && parameter.getFormat().equals("date")) {
                    return "\"@matchesDatePattern('yyyy-MM-dd')@\"";
                }
                if (parameter.getFormat() != null && parameter.getFormat().equals("date-time")) {
                    return "\"@matchesDatePattern('yyyy-MM-dd'T'hh:mm:ss')@\"";
                }
                if (StringUtils.hasText((String)parameter.getPattern())) {
                    return "\"@matches(" + parameter.getPattern() + ")@\"";
                }
                if (parameter.getEnum() != null && !parameter.getEnum().isEmpty()) {
                    return "\"@matches(" + parameter.getEnum().stream().collect(Collectors.joining("|")) + ")@\"";
                }
                return "@notEmpty()@";
            }
            case "boolean": {
                return "@matches(true|false)@";
            }
        }
        return "@ignore@";
    }

    private String createRandomValueExpression(AbstractSerializableParameter parameter) {
        switch (parameter.getType()) {
            case "integer": {
                return "citrus:randomNumber(10)";
            }
            case "string": {
                if (parameter.getFormat() != null && parameter.getFormat().equals("date")) {
                    return "\"citrus:currentDate('yyyy-MM-dd')\"";
                }
                if (parameter.getFormat() != null && parameter.getFormat().equals("date-time")) {
                    return "\"citrus:currentDate('yyyy-MM-dd'T'hh:mm:ss')\"";
                }
                if (StringUtils.hasText((String)parameter.getPattern())) {
                    return "\"citrus:randomValue(" + parameter.getPattern() + ")\"";
                }
                if (parameter.getEnum() != null && !parameter.getEnum().isEmpty()) {
                    return "\"citrus:randomEnumValue(" + parameter.getEnum().stream().collect(Collectors.joining(",")) + ")\"";
                }
                if (Optional.ofNullable(parameter.getFormat()).orElse("").equalsIgnoreCase("uuid")) {
                    return "citrus:randomUUID()";
                }
                return "citrus:randomString(10)";
            }
            case "boolean": {
                return "true";
            }
        }
        return "";
    }

    @Override
    public SwaggerJavaTestGenerator withSpec(String swaggerResource) {
        this.swaggerResource = swaggerResource;
        return this;
    }

    public SwaggerJavaTestGenerator withContextPath(String contextPath) {
        this.nameSuffix = contextPath;
        return this;
    }

    @Override
    public SwaggerJavaTestGenerator withNamePrefix(String prefix) {
        this.namePrefix = prefix;
        return this;
    }

    @Override
    public SwaggerJavaTestGenerator withNameSuffix(String suffix) {
        this.nameSuffix = suffix;
        return this;
    }

    @Override
    public SwaggerJavaTestGenerator withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    @Override
    public SwaggerJavaTestGenerator withInboundMappings(Map<String, String> mappings) {
        this.inboundDataDictionary.getMappings().putAll(mappings);
        return this;
    }

    @Override
    public SwaggerJavaTestGenerator withOutboundMappings(Map<String, String> mappings) {
        this.outboundDataDictionary.getMappings().putAll(mappings);
        return this;
    }

    @Override
    public SwaggerJavaTestGenerator withInboundMappingFile(String mappingFile) {
        this.inboundDataDictionary.setMappingFile(Resources.create((String)mappingFile));
        this.inboundDataDictionary.initialize();
        return this;
    }

    @Override
    public SwaggerJavaTestGenerator withOutboundMappingFile(String mappingFile) {
        this.outboundDataDictionary.setMappingFile(Resources.create((String)mappingFile));
        this.outboundDataDictionary.initialize();
        return this;
    }

    @Override
    public String getSwaggerResource() {
        return this.swaggerResource;
    }

    public void setSwaggerResource(String swaggerResource) {
        this.swaggerResource = swaggerResource;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    @Override
    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }
}

