/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.provider.http;

import com.squareup.javapoet.CodeBlock;
import java.util.Optional;
import java.util.stream.Stream;
import org.citrusframework.generate.provider.MessageCodeProvider;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.Message;
import org.citrusframework.util.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;

class HttpCodeProvider {
    private final MessageCodeProvider messageCodeProvider = new MessageCodeProvider();

    HttpCodeProvider() {
    }

    void provideRequestConfiguration(CodeBlock.Builder code, HttpMessage message) {
        String method = Optional.ofNullable(message.getRequestMethod()).map(Object::toString).orElse(RequestMethod.POST.name());
        this.providePath(code, message, method);
        this.messageCodeProvider.provideHeaderAndPayload(code, (Message)message);
        this.provideContentType(code, message);
        this.provideQueryParameter(code, message);
    }

    void provideResponseConfiguration(CodeBlock.Builder code, HttpMessage message) {
        if (message.getStatusCode() instanceof HttpStatus) {
            code.add(".response($T.$L)\n", new Object[]{HttpStatus.class, ((HttpStatus)message.getStatusCode()).name()});
        } else {
            code.add(".response($T.$L)\n", new Object[]{HttpStatus.class, "Status"});
        }
        this.messageCodeProvider.provideHeaderAndPayload(code, (Message)message);
    }

    private void provideContentType(CodeBlock.Builder code, HttpMessage message) {
        code.add(".contentType($S)\n", new Object[]{Optional.ofNullable(message.getHeader("Content-Type")).orElse("application/json")});
    }

    private void providePath(CodeBlock.Builder code, HttpMessage message, String method) {
        code.add(".$L($L)\n", new Object[]{method.toLowerCase(), Optional.ofNullable(message.getPath()).map(Object::toString).map(path -> "\"" + path + "\"").orElse("")});
    }

    private void provideQueryParameter(CodeBlock.Builder code, HttpMessage message) {
        if (message.getQueryParams() != null && !message.getQueryParams().isEmpty()) {
            message.getQueryParams().forEach((key, values) -> values.forEach(value -> code.add(".queryParam($S, $S)\n", new Object[]{key, value})));
        } else if (StringUtils.hasText((String)message.getQueryParamString())) {
            Stream.of(message.getQueryParamString().split(",")).map(nameValuePair -> nameValuePair.split("=")).forEach(param -> code.add(".queryParam($S, $S)\n", new Object[]{param[0], param[1]}));
        }
    }
}

