/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.javadsl;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Optional;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.generate.TestGenerator;
import org.citrusframework.generate.javadsl.JavaDslTestGenerator;
import org.citrusframework.generate.provider.CodeProvider;
import org.citrusframework.generate.provider.ReceiveCodeProvider;
import org.citrusframework.generate.provider.SendCodeProvider;
import org.citrusframework.generate.provider.http.ReceiveHttpRequestCodeProvider;
import org.citrusframework.generate.provider.http.ReceiveHttpResponseCodeProvider;
import org.citrusframework.generate.provider.http.SendHttpRequestCodeProvider;
import org.citrusframework.generate.provider.http.SendHttpResponseCodeProvider;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.Message;
import org.citrusframework.ws.message.SoapMessage;

public class MessagingJavaTestGenerator<T extends MessagingJavaTestGenerator<T>>
extends JavaDslTestGenerator<T> {
    private String endpoint;
    private Message request;
    private Message response;

    @Override
    protected JavaFile.Builder createJavaFileBuilder(TypeSpec.Builder testTypeBuilder) {
        return super.createJavaFileBuilder(testTypeBuilder).addStaticImport(SendMessageAction.Builder.class, new String[]{"send"}).addStaticImport(ReceiveMessageAction.Builder.class, new String[]{"receive"});
    }

    @Override
    protected List<CodeBlock> getActions() {
        List<CodeBlock> codeBlocks = super.getActions();
        if (this.getMode().equals((Object)TestGenerator.GeneratorMode.CLIENT)) {
            codeBlocks.add(this.getSendRequestCodeProvider(this.request).getCode(Optional.ofNullable(this.endpoint).orElseGet(() -> this.getMode().name().toLowerCase()), this.generateOutboundMessage(this.request)));
            if (this.response != null) {
                codeBlocks.add(this.getReceiveResponseCodeProvider(this.response).getCode(Optional.ofNullable(this.endpoint).orElseGet(() -> this.getMode().name().toLowerCase()), this.generateInboundMessage(this.response)));
            }
        } else if (this.getMode().equals((Object)TestGenerator.GeneratorMode.SERVER)) {
            codeBlocks.add(this.getReceiveRequestCodeProvider(this.request).getCode(Optional.ofNullable(this.endpoint).orElseGet(() -> this.getMode().name().toLowerCase()), this.generateInboundMessage(this.request)));
            if (this.response != null) {
                codeBlocks.add(this.getSendResponseCodeProvider(this.response).getCode(Optional.ofNullable(this.endpoint).orElseGet(() -> this.getMode().name().toLowerCase()), this.generateOutboundMessage(this.response)));
            }
        }
        return codeBlocks;
    }

    protected Message generateInboundMessage(Message message) {
        return message;
    }

    protected Message generateOutboundMessage(Message message) {
        return message;
    }

    protected <M extends Message> CodeProvider<M> getSendRequestCodeProvider(M message) {
        if (message instanceof HttpMessage) {
            return new SendHttpRequestCodeProvider();
        }
        if (message instanceof SoapMessage) {
            return new SendCodeProvider();
        }
        return new SendCodeProvider();
    }

    protected <M extends Message> CodeProvider<M> getReceiveResponseCodeProvider(M message) {
        if (message instanceof HttpMessage) {
            return new ReceiveHttpResponseCodeProvider();
        }
        if (message instanceof SoapMessage) {
            return new ReceiveCodeProvider();
        }
        return new ReceiveCodeProvider();
    }

    protected <M extends Message> CodeProvider<M> getSendResponseCodeProvider(M message) {
        if (message instanceof HttpMessage) {
            return new SendHttpResponseCodeProvider();
        }
        if (message instanceof SoapMessage) {
            return new SendCodeProvider();
        }
        return new SendCodeProvider();
    }

    protected <M extends Message> CodeProvider<M> getReceiveRequestCodeProvider(M message) {
        if (message instanceof HttpMessage) {
            return new ReceiveHttpRequestCodeProvider();
        }
        if (message instanceof SoapMessage) {
            return new ReceiveCodeProvider();
        }
        return new ReceiveCodeProvider();
    }

    public T withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return (T)((MessagingJavaTestGenerator)this.self);
    }

    public T withRequest(Message request) {
        this.request = request;
        return (T)((MessagingJavaTestGenerator)this.self);
    }

    public T withResponse(Message response) {
        this.response = response;
        return (T)((MessagingJavaTestGenerator)this.self);
    }

    public T addRequestHeader(String name, Object value) {
        this.request.setHeader(name, value);
        return (T)((MessagingJavaTestGenerator)this.self);
    }

    public T addResponseHeader(String name, Object value) {
        this.request.setHeader(name, value);
        return (T)((MessagingJavaTestGenerator)this.self);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }
}

