/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.provider.http;

import java.util.Optional;
import org.citrusframework.generate.provider.MessageActionProvider;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.model.testcase.http.ResponseHeadersType;
import org.citrusframework.model.testcase.http.SendResponseModel;
import org.springframework.http.HttpStatus;

public class SendHttpResponseActionProvider
implements MessageActionProvider<SendResponseModel, HttpMessage> {
    @Override
    public SendResponseModel getAction(String endpoint, HttpMessage message) {
        SendResponseModel response = new SendResponseModel();
        response.setServer(endpoint);
        SendResponseModel.Body body = new SendResponseModel.Body();
        body.setData((String)message.getPayload(String.class));
        response.setBody(body);
        ResponseHeadersType responseHeaders = new ResponseHeadersType();
        if (message.getStatusCode() instanceof HttpStatus) {
            responseHeaders.setStatus(((HttpStatus)message.getStatusCode()).toString());
            responseHeaders.setReasonPhrase(((HttpStatus)message.getStatusCode()).getReasonPhrase());
        } else {
            responseHeaders.setStatus("Status" + message.getStatusCode().value());
            responseHeaders.setReasonPhrase("Custom Status Code " + message.getStatusCode().value());
        }
        message.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("citrus_")).forEach(entry -> {
            ResponseHeadersType.Header header = new ResponseHeadersType.Header();
            header.setName((String)entry.getKey());
            header.setValue(Optional.ofNullable(entry.getValue()).map(Object::toString).orElse(""));
            responseHeaders.getHeaders().add(header);
        });
        response.setHeaders(responseHeaders);
        return response;
    }
}

