/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.javadsl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xsd2inst.SampleXmlUtil;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.generate.WsdlTestGenerator;
import org.citrusframework.generate.dictionary.InboundXmlDataDictionary;
import org.citrusframework.generate.dictionary.OutboundXmlDataDictionary;
import org.citrusframework.generate.javadsl.MessagingJavaTestGenerator;
import org.citrusframework.message.Message;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.StringUtils;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.ws.message.SoapMessage;
import org.citrusframework.xml.XmlConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsdlJavaTestGenerator
extends MessagingJavaTestGenerator<WsdlJavaTestGenerator>
implements WsdlTestGenerator<WsdlJavaTestGenerator> {
    private static final Logger logger = LoggerFactory.getLogger(WsdlJavaTestGenerator.class);
    private static final Pattern COUNT_NS = Pattern.compile("xmlns:");
    private String wsdl;
    private String operation;
    private String namePrefix;
    private String nameSuffix = "_IT";
    private final InboundXmlDataDictionary inboundDataDictionary = new InboundXmlDataDictionary();
    private final OutboundXmlDataDictionary outboundDataDictionary = new OutboundXmlDataDictionary();

    @Override
    public void create() {
        XmlObject[] operations;
        String wsdlNsDelaration = "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/' ";
        String soapNsDelaration = "declare namespace soap='http://schemas.xmlsoap.org/wsdl/soap/' ";
        XmlObject wsdlObject = this.compileWsdl(this.wsdl);
        SchemaTypeSystem schemaTypeSystem = this.compileXsd(wsdlObject);
        logger.info("WSDL compilation successful");
        String serviceName = this.evaluateAsString(wsdlObject, wsdlNsDelaration + ".//wsdl:portType/@name");
        logger.info("Found service: " + serviceName);
        if (!StringUtils.hasText((String)this.namePrefix)) {
            this.withNamePrefix(serviceName + "_");
        }
        logger.info("Found service operations:");
        XmlObject[] messages = wsdlObject.selectPath(wsdlNsDelaration + ".//wsdl:message");
        for (XmlObject operation : operations = wsdlObject.selectPath(wsdlNsDelaration + ".//wsdl:portType/wsdl:operation")) {
            logger.info(this.evaluateAsString(operation, wsdlNsDelaration + "./@name"));
        }
        logger.info("Generating test cases for service operations ...");
        for (XmlObject operation : operations) {
            XmlObject[] bindingOperations;
            SoapMessage request = new SoapMessage();
            SoapMessage response = new SoapMessage();
            String operationName = this.evaluateAsString(operation, wsdlNsDelaration + "./@name");
            if (StringUtils.hasText((String)this.operation) && !operationName.equals(this.operation)) continue;
            for (XmlObject bindingOperation : bindingOperations = wsdlObject.selectPath(wsdlNsDelaration + ".//wsdl:binding/wsdl:operation")) {
                XmlObject[] bindingOperationName = this.evaluateAsString(bindingOperation, wsdlNsDelaration + "./@name");
                if (!bindingOperationName.equals(operationName)) continue;
                String soapAction = this.removeNsPrefix(this.evaluateAsString(bindingOperation, soapNsDelaration + "./soap:operation/@soapAction"));
                request.soapAction(soapAction);
                break;
            }
            String inputMessage = this.removeNsPrefix(this.evaluateAsString(operation, wsdlNsDelaration + "./wsdl:input/@message"));
            String outputMessage = this.removeNsPrefix(this.evaluateAsString(operation, wsdlNsDelaration + "./wsdl:output/@message"));
            String inputElement = null;
            String outputElement = null;
            for (XmlObject message : messages) {
                String messageName = this.evaluateAsString(message, wsdlNsDelaration + "./@name");
                if (messageName.equals(inputMessage)) {
                    inputElement = this.removeNsPrefix(this.evaluateAsString(message, wsdlNsDelaration + "./wsdl:part/@element"));
                }
                if (!messageName.equals(outputMessage)) continue;
                outputElement = this.removeNsPrefix(this.evaluateAsString(message, wsdlNsDelaration + "./wsdl:part/@element"));
            }
            this.withName(this.namePrefix + operationName + this.nameSuffix);
            SchemaType requestElem = this.getSchemaType(schemaTypeSystem, operationName, inputElement);
            request.setPayload((Object)SampleXmlUtil.createSampleForType((SchemaType)requestElem));
            this.withRequest((Message)request);
            SchemaType responseElem = this.getSchemaType(schemaTypeSystem, operationName, outputElement);
            response.setPayload((Object)SampleXmlUtil.createSampleForType((SchemaType)responseElem));
            this.withResponse((Message)response);
            XmlConfigurer configurer = new XmlConfigurer();
            configurer.initialize();
            configurer.setSerializeSettings(Collections.singletonMap("xml-declaration", false));
            XMLUtils.initialize((XmlConfigurer)configurer);
            super.create();
            logger.info("Successfully created new test case " + this.getTargetPackage() + "." + this.getName());
        }
    }

    @Override
    protected Message generateInboundMessage(Message message) {
        this.inboundDataDictionary.process(message, new TestContext());
        return super.generateInboundMessage(message);
    }

    @Override
    protected Message generateOutboundMessage(Message message) {
        this.outboundDataDictionary.process(message, new TestContext());
        return super.generateOutboundMessage(message);
    }

    private XmlObject compileWsdl(String wsdl) {
        Resource wsdlFile = Resources.create((String)wsdl);
        if (!wsdlFile.exists()) {
            throw new CitrusRuntimeException("Unable to read WSDL - does not exist in " + wsdlFile.getLocation());
        }
        try {
            return (XmlObject)XmlObject.Factory.parse(wsdlFile.getFile(), new XmlOptions().setLoadLineNumbers().setLoadMessageDigest().setCompileDownloadUrls());
        }
        catch (XmlException e) {
            for (Object error : e.getErrors()) {
                logger.error(((XmlError)error).getLine() + error.toString());
            }
            throw new CitrusRuntimeException("WSDL could not be parsed", (Throwable)e);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("WSDL could not be parsed", (Throwable)e);
        }
    }

    private SchemaTypeSystem compileXsd(XmlObject wsdl) {
        String[] namespacesWsdl = this.extractNamespacesOnWsdlLevel(wsdl);
        String schemaNsPrefix = this.extractSchemaNamespacePrefix(wsdl);
        String[] schemas = this.getNestedSchemas(wsdl, namespacesWsdl, schemaNsPrefix);
        XmlObject[] xsd = new XmlObject[schemas.length];
        try {
            for (int i = 0; i < schemas.length; ++i) {
                xsd[i] = (XmlObject)XmlObject.Factory.parse(schemas[i], new XmlOptions().setLoadLineNumbers().setLoadMessageDigest().setCompileDownloadUrls());
            }
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to parse XSD schema", (Throwable)e);
        }
        SchemaTypeSystem schemaTypeSystem = null;
        try {
            schemaTypeSystem = XmlBeans.compileXsd((XmlObject[])xsd, (SchemaTypeLoader)XmlBeans.getContextTypeLoader(), (XmlOptions)new XmlOptions());
        }
        catch (XmlException e) {
            for (Object error : e.getErrors()) {
                logger.error("Line " + ((XmlError)error).getLine() + ": " + error.toString());
            }
            throw new CitrusRuntimeException("Failed to compile XSD schema", (Throwable)e);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to compile XSD schema", (Throwable)e);
        }
        return schemaTypeSystem;
    }

    private SchemaType getSchemaType(SchemaTypeSystem schemaTypeSystem, String operation, String elementName) {
        for (SchemaType elem : schemaTypeSystem.documentTypes()) {
            if (!elem.getContentModel().getName().getLocalPart().equals(elementName)) continue;
            return elem;
        }
        throw new CitrusRuntimeException("Unable to find schema type declaration '" + elementName + "' for WSDL operation '" + operation + "'");
    }

    private String removeNsPrefix(String elementName) {
        return elementName.indexOf(58) != -1 ? elementName.substring(elementName.indexOf(58) + 1) : elementName;
    }

    private String[] getNestedSchemas(XmlObject wsdl, String[] namespacesWsdl, String schemaNsPrefix) {
        ArrayList<String> schemas = new ArrayList<String>();
        String openedStartTag = "<" + schemaNsPrefix + "schema";
        String endTag = "</" + schemaNsPrefix + "schema>";
        int cursor = 0;
        while (wsdl.xmlText().indexOf(openedStartTag, cursor) != -1) {
            int begin = wsdl.xmlText().indexOf(openedStartTag, cursor);
            int end = wsdl.xmlText().indexOf(endTag, begin) + endTag.length();
            int insertPointNamespacesWsdl = wsdl.xmlText().indexOf(" ", begin);
            StringBuilder builder = new StringBuilder();
            builder.append(wsdl.xmlText().substring(begin, insertPointNamespacesWsdl)).append(" ");
            for (String nsWsdl : namespacesWsdl) {
                String nsPrefix = nsWsdl.substring(0, nsWsdl.indexOf("="));
                if (wsdl.xmlText().substring(begin, end).contains(nsPrefix)) continue;
                builder.append(nsWsdl).append(" ");
            }
            builder.append(wsdl.xmlText().substring(insertPointNamespacesWsdl, end));
            schemas.add(builder.toString());
            cursor = end;
        }
        return schemas.toArray(new String[0]);
    }

    private String extractSchemaNamespacePrefix(XmlObject wsdl) {
        String schemaNsPrefix = "";
        if (wsdl.xmlText().contains(":schema")) {
            int cursor;
            for (int i = cursor = wsdl.xmlText().indexOf(":schema"); i > cursor - 100; --i) {
                schemaNsPrefix = wsdl.xmlText().substring(i, cursor);
                if (!schemaNsPrefix.startsWith("<")) continue;
                return schemaNsPrefix.substring(1) + ":";
            }
        }
        return schemaNsPrefix;
    }

    private String[] extractNamespacesOnWsdlLevel(XmlObject wsdl) {
        int cursor = wsdl.xmlText().indexOf(":") + ":definitions ".length();
        String nsWsdlOrig = wsdl.xmlText().substring(cursor, wsdl.xmlText().indexOf(">", cursor));
        int noNs = (int)COUNT_NS.matcher(nsWsdlOrig).results().count();
        String[] namespacesWsdl = new String[noNs];
        cursor = 0;
        for (int i = 0; i < noNs; ++i) {
            int begin = nsWsdlOrig.indexOf("xmlns:", cursor);
            int end = nsWsdlOrig.indexOf("\"", begin + 20);
            namespacesWsdl[i] = nsWsdlOrig.substring(begin, end) + "\"";
            cursor = end;
        }
        return namespacesWsdl;
    }

    private String evaluateAsString(XmlObject rootObject, String pathToAttribute) {
        XmlObject[] xmlObject = rootObject.selectPath(pathToAttribute);
        if (xmlObject.length == 0) {
            throw new CitrusRuntimeException("Unable to find element attribute " + pathToAttribute);
        }
        int begin = xmlObject[0].xmlText().indexOf(">") + 1;
        int end = xmlObject[0].xmlText().lastIndexOf("</");
        return xmlObject[0].xmlText().substring(begin, end);
    }

    @Override
    public WsdlJavaTestGenerator withWsdl(String wsdlResource) {
        this.wsdl = wsdlResource;
        return this;
    }

    @Override
    public WsdlJavaTestGenerator withNameSuffix(String suffix) {
        this.nameSuffix = suffix;
        return this;
    }

    @Override
    public WsdlJavaTestGenerator withNamePrefix(String prefix) {
        this.namePrefix = prefix;
        return this;
    }

    @Override
    public WsdlJavaTestGenerator withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    @Override
    public WsdlJavaTestGenerator withInboundMappings(Map<String, String> mappings) {
        this.inboundDataDictionary.getMappings().putAll(mappings);
        return this;
    }

    @Override
    public WsdlJavaTestGenerator withOutboundMappings(Map<String, String> mappings) {
        this.outboundDataDictionary.getMappings().putAll(mappings);
        return this;
    }

    @Override
    public WsdlJavaTestGenerator withInboundMappingFile(String mappingFile) {
        this.inboundDataDictionary.setMappingFile(Resources.create((String)mappingFile));
        this.inboundDataDictionary.initialize();
        return this;
    }

    @Override
    public WsdlJavaTestGenerator withOutboundMappingFile(String mappingFile) {
        this.outboundDataDictionary.setMappingFile(Resources.create((String)mappingFile));
        this.outboundDataDictionary.initialize();
        return this;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    @Override
    public String getWsdl() {
        return this.wsdl;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    @Override
    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }
}

