/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.provider;

import com.squareup.javapoet.CodeBlock;
import java.util.Optional;
import org.citrusframework.message.Message;
import org.citrusframework.util.StringUtils;

public class MessageCodeProvider {
    public void provideHeaderAndPayload(CodeBlock.Builder code, Message message) {
        this.provideMessage(code, message);
        this.provideHeader(code, message);
        this.providePayload(code, message);
    }

    private void provideMessage(CodeBlock.Builder code, Message message) {
        if (StringUtils.hasText((String)((String)message.getPayload(String.class))) || !message.getHeaders().isEmpty()) {
            code.add(".message()\n", new Object[]{message.getPayload(String.class)});
        }
    }

    private void provideHeader(CodeBlock.Builder code, Message message) {
        if (!message.getHeaders().isEmpty()) {
            message.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("citrus_")).forEach(entry -> code.add(".header($S, $S)\n", new Object[]{entry.getKey(), Optional.ofNullable(entry.getValue()).map(Object::toString).orElse("")}));
        }
    }

    private void providePayload(CodeBlock.Builder code, Message message) {
        if (StringUtils.hasText((String)((String)message.getPayload(String.class)))) {
            code.add(".body($S)\n", new Object[]{message.getPayload(String.class)});
        }
    }
}

