/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.provider.soap;

import java.util.Optional;
import org.citrusframework.generate.provider.MessageActionProvider;
import org.citrusframework.model.testcase.core.ReceiveModel;
import org.citrusframework.model.testcase.ws.ReceiveModel;
import org.citrusframework.ws.message.SoapMessage;

public class ReceiveSoapRequestActionProvider
implements MessageActionProvider<ReceiveModel, SoapMessage> {
    @Override
    public ReceiveModel getAction(String endpoint, SoapMessage message) {
        ReceiveModel request = new ReceiveModel();
        request.setEndpoint(endpoint);
        request.setSoapAction(message.getSoapAction());
        ReceiveModel.Message receiveMessage = new ReceiveModel.Message();
        receiveMessage.setData((String)message.getPayload(String.class));
        request.setMessage(receiveMessage);
        if (message.getHeaders() != null && !message.getHeaders().isEmpty()) {
            ReceiveModel.Header header = new ReceiveModel.Header();
            message.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("citrus_")).forEach(entry -> {
                ReceiveModel.Header.Element element = new ReceiveModel.Header.Element();
                element.setName((String)entry.getKey());
                element.setValue(Optional.ofNullable(entry.getValue()).map(Object::toString).orElse(""));
                header.getElements().add(element);
            });
            request.setHeader(header);
        }
        return request;
    }
}

