/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.generate.xml;

import java.util.Collections;
import java.util.Map;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xsd2inst.SampleXmlUtil;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.generate.XsdTestGenerator;
import org.citrusframework.generate.dictionary.InboundXmlDataDictionary;
import org.citrusframework.generate.dictionary.OutboundXmlDataDictionary;
import org.citrusframework.generate.xml.MessagingXmlTestGenerator;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.StringUtils;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.xml.XmlConfigurer;

public class XsdXmlTestGenerator
extends MessagingXmlTestGenerator<XsdXmlTestGenerator>
implements XsdTestGenerator<XsdXmlTestGenerator> {
    private String xsd;
    private String requestMessage;
    private String responseMessage;
    private String nameSuffix = "IT";
    private final InboundXmlDataDictionary inboundDataDictionary = new InboundXmlDataDictionary();
    private final OutboundXmlDataDictionary outboundDataDictionary = new OutboundXmlDataDictionary();

    @Override
    public void create() {
        SchemaTypeSystem schemaTypeSystem = this.compileXsd(this.xsd);
        SchemaType[] globalElems = schemaTypeSystem.documentTypes();
        SchemaType requestElem = null;
        SchemaType responseElem = null;
        if (!StringUtils.hasText((String)this.getName())) {
            this.withName(this.getTestNameSuggestion());
        }
        if (!StringUtils.hasText((String)this.responseMessage)) {
            this.responseMessage = this.getResponseMessageSuggestion();
        }
        for (SchemaType elem : globalElems) {
            if (!elem.getContentModel().getName().getLocalPart().equals(this.requestMessage)) continue;
            requestElem = elem;
            break;
        }
        for (SchemaType elem : globalElems) {
            if (!elem.getContentModel().getName().getLocalPart().equals(this.responseMessage)) continue;
            responseElem = elem;
            break;
        }
        if (requestElem == null) {
            throw new CitrusRuntimeException(String.format("Unable to find element with name '%s' in XSD %s", this.requestMessage, this.xsd));
        }
        this.withRequest((Message)new DefaultMessage((Object)SampleXmlUtil.createSampleForType((SchemaType)requestElem)));
        if (responseElem != null) {
            this.withResponse((Message)new DefaultMessage((Object)SampleXmlUtil.createSampleForType((SchemaType)responseElem)));
        } else {
            this.withResponse(null);
        }
        XmlConfigurer configurer = new XmlConfigurer();
        configurer.initialize();
        configurer.setSerializeSettings(Collections.singletonMap("xml-declaration", false));
        XMLUtils.initialize((XmlConfigurer)configurer);
        super.create();
    }

    @Override
    protected Message generateInboundMessage(Message message) {
        this.inboundDataDictionary.process(message, new TestContext());
        return super.generateInboundMessage(message);
    }

    @Override
    protected Message generateOutboundMessage(Message message) {
        this.outboundDataDictionary.process(message, new TestContext());
        return super.generateOutboundMessage(message);
    }

    @Override
    public String getResponseMessageSuggestion() {
        Object suggestion = this.requestMessage.endsWith("Req") ? this.requestMessage.substring(0, this.requestMessage.indexOf("Req")) + "Res" : (this.requestMessage.endsWith("Request") ? this.requestMessage.substring(0, this.requestMessage.indexOf("Request")) + "Response" : (this.requestMessage.endsWith("RequestMessage") ? this.requestMessage.substring(0, this.requestMessage.indexOf("RequestMessage")) + "ResponseMessage" : ""));
        return suggestion;
    }

    public String getTestNameSuggestion() {
        String suggestion = this.requestMessage.endsWith("Req") ? this.requestMessage.substring(0, this.requestMessage.indexOf("Req")) + this.nameSuffix : (this.requestMessage.endsWith("Request") ? this.requestMessage.substring(0, this.requestMessage.indexOf("Request")) + this.nameSuffix : (this.requestMessage.endsWith("RequestMessage") ? this.requestMessage.substring(0, this.requestMessage.indexOf("RequestMessage")) + this.nameSuffix : this.requestMessage + this.nameSuffix));
        return suggestion;
    }

    private SchemaTypeSystem compileXsd(String xsd) {
        XmlObject xsdObject;
        Resource xsdFile = Resources.create((String)xsd);
        if (!xsdFile.exists()) {
            throw new CitrusRuntimeException("Unable to read XSD - does not exist in " + xsdFile.getLocation());
        }
        try {
            xsdObject = (XmlObject)XmlObject.Factory.parse(xsdFile.getFile(), new XmlOptions().setLoadLineNumbers().setLoadMessageDigest().setCompileDownloadUrls());
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to parse XSD schema", (Throwable)e);
        }
        XmlObject[] schemas = new XmlObject[]{xsdObject};
        try {
            return XmlBeans.compileXsd((XmlObject[])schemas, (SchemaTypeLoader)XmlBeans.getContextTypeLoader(), (XmlOptions)new XmlOptions());
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to compile XSD schema", (Throwable)e);
        }
    }

    @Override
    public XsdXmlTestGenerator withXsd(String xsdResource) {
        this.xsd = xsdResource;
        return this;
    }

    @Override
    public XsdXmlTestGenerator withRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
        return this;
    }

    @Override
    public XsdXmlTestGenerator withResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
        return this;
    }

    @Override
    public XsdXmlTestGenerator withNameSuffix(String suffix) {
        this.nameSuffix = suffix;
        return this;
    }

    @Override
    public XsdXmlTestGenerator withInboundMappings(Map<String, String> mappings) {
        this.inboundDataDictionary.getMappings().putAll(mappings);
        return this;
    }

    @Override
    public XsdXmlTestGenerator withOutboundMappings(Map<String, String> mappings) {
        this.outboundDataDictionary.getMappings().putAll(mappings);
        return this;
    }

    @Override
    public XsdXmlTestGenerator withInboundMappingFile(String mappingFile) {
        this.inboundDataDictionary.setMappingFile(Resources.create((String)mappingFile));
        this.inboundDataDictionary.initialize();
        return this;
    }

    @Override
    public XsdXmlTestGenerator withOutboundMappingFile(String mappingFile) {
        this.outboundDataDictionary.setMappingFile(Resources.create((String)mappingFile));
        this.outboundDataDictionary.initialize();
        return this;
    }

    public void setXsd(String xsd) {
        this.xsd = xsd;
    }

    @Override
    public String getXsd() {
        return this.xsd;
    }

    public void setRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
    }

    @Override
    public String getRequestMessage() {
        return this.requestMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    @Override
    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }
}

