/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.HeaderValidator;
import org.citrusframework.validation.ValidationUtils;
import org.citrusframework.validation.context.HeaderValidationContext;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class HamcrestHeaderValidator
implements HeaderValidator {
    private static Logger log = LoggerFactory.getLogger(HamcrestHeaderValidator.class);

    public void validateHeader(String headerName, Object receivedValue, Object controlValue, TestContext context, HeaderValidationContext validationContext) {
        try {
            if (controlValue instanceof Matcher) {
                Assert.isTrue((boolean)((Matcher)controlValue).matches(receivedValue), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Values not matching for header '" + headerName + "'"), (Object)controlValue, (Object)receivedValue));
            } else {
                IsEqual equalMatcher = new IsEqual(controlValue);
                Assert.isTrue((boolean)equalMatcher.matches(receivedValue), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for header '" + headerName + "'"), (Object)controlValue, (Object)receivedValue));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Validation failed:", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating header element: " + headerName + "='" + controlValue + "': OK.");
        }
    }

    public boolean supports(String headerName, Class<?> type) {
        return type != null && Matcher.class.isAssignableFrom(type);
    }
}

