/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.HeaderValidator;
import org.citrusframework.validation.ValidationUtils;
import org.citrusframework.validation.context.HeaderValidationContext;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HamcrestHeaderValidator
implements HeaderValidator {
    private static final Logger logger = LoggerFactory.getLogger(HamcrestHeaderValidator.class);

    public void validateHeader(String headerName, Object receivedValue, Object controlValue, TestContext context, HeaderValidationContext validationContext) {
        if (controlValue instanceof Matcher) {
            if (!((Matcher)controlValue).matches(receivedValue)) {
                throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("Header validation failed: Values not matching for header '" + headerName + "'"), (Object)controlValue, (Object)receivedValue));
            }
        } else {
            IsEqual equalMatcher = new IsEqual(controlValue);
            if (!equalMatcher.matches(receivedValue)) {
                throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("Header validation failed: Values not equal for header '" + headerName + "'"), (Object)controlValue, (Object)receivedValue));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Header validation: " + headerName + "='" + controlValue + "': OK.");
        }
    }

    public boolean supports(String headerName, Class<?> type) {
        return type != null && Matcher.class.isAssignableFrom(type);
    }
}

