/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher.hamcrest;

import java.util.Optional;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.spi.TypeResolver;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HamcrestMatcherProvider {
    public static final Logger logger = LoggerFactory.getLogger(HamcrestMatcherProvider.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/hamcrest/matcher/provider";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/hamcrest/matcher/provider");

    public static Optional<HamcrestMatcherProvider> lookup(String matcherName) {
        try {
            return Optional.of((HamcrestMatcherProvider)TYPE_RESOLVER.resolve(matcherName, new Object[0]));
        }
        catch (CitrusRuntimeException e) {
            logger.warn(String.format("Failed to resolve Hamcrest matcher provider from resource '%s/%s'", RESOURCE_PATH, matcherName));
            return Optional.empty();
        }
    }

    public static boolean canResolve(String matcherName) {
        try {
            TYPE_RESOLVER.resolve(matcherName, new Object[0]);
            return true;
        }
        catch (CitrusRuntimeException e) {
            return false;
        }
    }

    public String getName();

    public Matcher<?> provideMatcher(String var1);
}

