/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.common.Named;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.json.schema.SimpleJsonSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class JsonSchemaRepository
implements Named,
InitializingPhase {
    private String name;
    private List<SimpleJsonSchema> schemas = new ArrayList<SimpleJsonSchema>();
    private List<String> locations = new ArrayList<String>();
    private static Logger log = LoggerFactory.getLogger(JsonSchemaRepository.class);

    public void setName(String name) {
        this.name = name;
    }

    public void initialize() {
        try {
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            for (String location : this.locations) {
                Resource[] findings;
                for (Resource resource : findings = resourcePatternResolver.getResources(location)) {
                    this.addSchemas(resource);
                }
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to initialize Json schema repository", (Throwable)e);
        }
    }

    private void addSchemas(Resource resource) {
        if (resource.getFilename().endsWith(".json")) {
            if (log.isDebugEnabled()) {
                log.debug("Loading json schema resource " + resource.getFilename());
            }
            SimpleJsonSchema simpleJsonSchema = new SimpleJsonSchema(resource);
            simpleJsonSchema.initialize();
            this.schemas.add(simpleJsonSchema);
        } else {
            log.warn("Skipped resource other than json schema for repository (" + resource.getFilename() + ")");
        }
    }

    public String getName() {
        return this.name;
    }

    public List<SimpleJsonSchema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<SimpleJsonSchema> schemas) {
        this.schemas = schemas;
    }

    public static Logger getLog() {
        return log;
    }

    public static void setLog(Logger log) {
        JsonSchemaRepository.log = log;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }
}

