/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.builder.DefaultPayloadBuilder;

public class ObjectMappingPayloadBuilder
extends DefaultPayloadBuilder {
    private final ObjectMapper mapper;
    private final String mapperName;

    public ObjectMappingPayloadBuilder(Object model) {
        super(model);
        this.mapper = null;
        this.mapperName = null;
    }

    public ObjectMappingPayloadBuilder(Object model, ObjectMapper mapper) {
        super(model);
        this.mapper = mapper;
        this.mapperName = null;
    }

    public ObjectMappingPayloadBuilder(Object model, String mapperName) {
        super(model);
        this.mapperName = mapperName;
        this.mapper = null;
    }

    public Object buildPayload(TestContext context) {
        if (this.getPayload() == null || this.getPayload() instanceof String) {
            return super.buildPayload(context);
        }
        if (this.mapper != null) {
            return this.buildPayload(this.mapper, this.getPayload(), context);
        }
        if (this.mapperName != null) {
            if (context.getReferenceResolver().isResolvable(this.mapperName)) {
                ObjectMapper objectMapper = (ObjectMapper)context.getReferenceResolver().resolve(this.mapperName, ObjectMapper.class);
                return this.buildPayload(objectMapper, this.getPayload(), context);
            }
            throw new CitrusRuntimeException(String.format("Unable to find proper object mapper for name '%s'", this.mapperName));
        }
        Map mappers = context.getReferenceResolver().resolveAll(ObjectMapper.class);
        if (mappers.size() == 1) {
            return this.buildPayload((ObjectMapper)mappers.values().iterator().next(), this.getPayload(), context);
        }
        throw new CitrusRuntimeException(String.format("Unable to auto detect object mapper - found %d matching mapper instances in reference resolver", mappers.size()));
    }

    private Object buildPayload(ObjectMapper mapper, Object model, TestContext context) {
        try {
            return context.replaceDynamicContentInString(mapper.writer().writeValueAsString(model));
        }
        catch (JsonProcessingException e) {
            throw new CitrusRuntimeException("Failed to map object graph for message payload", (Throwable)e);
        }
    }
}

