/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.json.schema;

import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.springframework.core.io.Resource;

public class SimpleJsonSchema
implements InitializingPhase {
    private JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V4);
    private Resource json;
    private JsonSchema schema;

    public SimpleJsonSchema(Resource resource) {
        this.json = resource;
    }

    public SimpleJsonSchema() {
    }

    public void initialize() {
        try (FileInputStream fileInputStream = new FileInputStream(this.json.getFile());){
            this.schema = this.jsonSchemaFactory.getSchema((InputStream)fileInputStream);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to load Json schema", (Throwable)e);
        }
    }

    public Resource getJson() {
        return this.json;
    }

    public void setJson(Resource json) {
        this.json = json;
    }

    public JsonSchema getSchema() {
        return this.schema;
    }

    public void setSchema(JsonSchema schema) {
        this.schema = schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleJsonSchema that = (SimpleJsonSchema)o;
        return Objects.equals(this.jsonSchemaFactory, that.jsonSchemaFactory) && Objects.equals(this.json, that.json) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.jsonSchemaFactory, this.json, this.schema);
    }
}

