/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.stream.Stream;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.ValidationUtils;

public class JsonElementValidatorItem<T> {
    private final String name;
    private final Integer index;
    public final T actual;
    public final T expected;
    private JsonElementValidatorItem<?> parent;

    public static JsonElementValidatorItem<Object> parseJson(int permissiveMode, String actualJson, String expectedJson) {
        JSONParser parser = new JSONParser(permissiveMode);
        try {
            return new JsonElementValidatorItem<Object>(null, parser.parse(actualJson), parser.parse(expectedJson));
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException("Failed to parse JSON text", (Throwable)e);
        }
    }

    public JsonElementValidatorItem(int index, T actual, T expected) {
        this.name = null;
        this.index = index;
        this.actual = actual;
        this.expected = expected;
    }

    public JsonElementValidatorItem(String name, T actual, T expected) {
        this.name = name;
        this.index = null;
        this.actual = actual;
        this.expected = expected;
    }

    public String actualAsStringOrNull() {
        return this.actual == null ? null : this.actual.toString();
    }

    public String expectedAsStringOrNull() {
        return this.expected == null ? null : this.expected.toString();
    }

    public <O> JsonElementValidatorItem<O> ensureType(Class<O> type) {
        JsonElementValidatorItem self = this;
        if (this.actual != null && !type.isInstance(this.actual) || this.expected != null && !type.isInstance(this.expected)) {
            throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)("Type mismatch for JSON entry '" + this.name + "'"), (Object)type.getSimpleName(), this.actual == null ? null : this.actual.getClass().getSimpleName()));
        }
        return self;
    }

    public JsonElementValidatorItem<T> parent(JsonElementValidatorItem<?> parent) {
        this.parent = parent;
        return this;
    }

    public String getJsonPath() {
        String parentPath;
        String string = parentPath = this.parent == null ? "$" : this.parent.getJsonPath();
        if (this.index != null) {
            return parentPath + "[%s]".formatted(this.index);
        }
        if (this.name != null) {
            return parentPath + "['%s']".formatted(this.name);
        }
        return parentPath;
    }

    public String getName() {
        if (this.index != null) {
            return "[%s]".formatted(this.index);
        }
        if (this.name != null) {
            return this.name;
        }
        return "$";
    }

    public JsonElementValidatorItem<?> getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public boolean isPathIgnoredBy(String jsonPathExpression) {
        String currentPath = this.getJsonPath();
        return Stream.concat(this.getAllMatchedPathsInJson(jsonPathExpression, this.getRoot().expected), this.getAllMatchedPathsInJson(jsonPathExpression, this.getRoot().actual)).anyMatch(currentPath::equals);
    }

    private Stream<String> getAllMatchedPathsInJson(String jsonPathExpression, Object json) {
        List foundJsonPaths;
        Configuration config = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();
        try {
            foundJsonPaths = (List)JsonPath.using((Configuration)config).parse(json).read(jsonPathExpression, new Predicate[0]);
        }
        catch (JsonPathException e) {
            return Stream.of(new String[0]);
        }
        return foundJsonPaths.stream();
    }
}

