/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.json;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ReadContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.json.JsonPathUtils;
import org.citrusframework.message.Message;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.AbstractMessageValidator;
import org.citrusframework.validation.ValidationUtils;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.json.JsonPathMessageValidationContext;
import org.citrusframework.validation.json.JsonTextMessageValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathMessageValidator
extends AbstractMessageValidator<JsonPathMessageValidationContext> {
    private static final Logger logger = LoggerFactory.getLogger(JsonPathMessageValidator.class);

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, JsonPathMessageValidationContext validationContext) throws ValidationException {
        if (validationContext.getJsonPathExpressions() == null || validationContext.getJsonPathExpressions().isEmpty()) {
            return;
        }
        if (receivedMessage.getPayload() == null || !StringUtils.hasText((String)((String)receivedMessage.getPayload(String.class)))) {
            throw new ValidationException("Unable to validate message elements - receive message payload was empty");
        }
        logger.debug("Start JSONPath element validation ...");
        try {
            JSONParser parser = new JSONParser(4032);
            Object receivedJson = parser.parse((String)receivedMessage.getPayload(String.class));
            DocumentContext readerContext = JsonPath.parse((Object)receivedJson);
            for (Map.Entry entry : validationContext.getJsonPathExpressions().entrySet()) {
                Object expectedValue = entry.getValue();
                if (expectedValue instanceof String) {
                    expectedValue = context.replaceDynamicContentInString(String.valueOf(expectedValue));
                }
                String jsonPathExpression = context.replaceDynamicContentInString((String)entry.getKey());
                Object jsonPathResult = JsonPathUtils.evaluate((ReadContext)readerContext, jsonPathExpression);
                ValidationUtils.validateValues((Object)jsonPathResult, expectedValue, (String)jsonPathExpression, (TestContext)context);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Validating element: " + jsonPathExpression + "='" + expectedValue + "': OK.");
            }
            logger.info("JSONPath element validation successful: All values OK");
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException("Failed to parse JSON text", (Throwable)e);
        }
    }

    protected Class<JsonPathMessageValidationContext> getRequiredValidationContextType() {
        return JsonPathMessageValidationContext.class;
    }

    public JsonPathMessageValidationContext findValidationContext(List<ValidationContext> validationContexts) {
        Map jsonPathExpressions;
        List jsonPathMessageValidationContexts = validationContexts.stream().filter(JsonPathMessageValidationContext.class::isInstance).map(JsonPathMessageValidationContext.class::cast).collect(Collectors.toList());
        if (jsonPathMessageValidationContexts.size() > 1 && !(jsonPathExpressions = jsonPathMessageValidationContexts.stream().map(JsonPathMessageValidationContext::getJsonPathExpressions).reduce((collect, map) -> {
            collect.putAll(map);
            return collect;
        }).orElseGet(Collections::emptyMap)).isEmpty()) {
            return new JsonPathMessageValidationContext.Builder().expressions(jsonPathExpressions).build();
        }
        return (JsonPathMessageValidationContext)super.findValidationContext(validationContexts);
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return new JsonTextMessageValidator().supportsMessageType(messageType, message);
    }
}

