/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.json;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.json.JsonSettings;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageType;
import org.citrusframework.util.MessageUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.AbstractMessageValidator;
import org.citrusframework.validation.json.JsonElementValidator;
import org.citrusframework.validation.json.JsonElementValidatorItem;
import org.citrusframework.validation.json.JsonMessageValidationContext;
import org.citrusframework.validation.json.schema.JsonSchemaValidation;

public class JsonTextMessageValidator
extends AbstractMessageValidator<JsonMessageValidationContext> {
    private boolean strict = JsonSettings.isStrict();
    private int permissiveMode = JsonSettings.getPermissiveMoe();
    private JsonSchemaValidation jsonSchemaValidation = new JsonSchemaValidation();
    private JsonElementValidator.Provider elementValidatorProvider = JsonElementValidator.Provider.DEFAULT;

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, JsonMessageValidationContext validationContext) {
        logger.debug("Start JSON message validation ...");
        if (validationContext.isSchemaValidationEnabled()) {
            this.jsonSchemaValidation.validate(receivedMessage, context, validationContext);
        }
        String receivedJsonText = (String)receivedMessage.getPayload(String.class);
        String controlJsonText = context.replaceDynamicContentInString((String)controlMessage.getPayload(String.class));
        if (!StringUtils.hasText((String)controlJsonText)) {
            logger.debug("Skip message payload validation as no control message was defined");
            return;
        }
        if (!StringUtils.hasText((String)receivedJsonText)) {
            throw new ValidationException("Validation failed - expected message contents, but received empty message!");
        }
        this.elementValidatorProvider.getValidator(this.strict, context, validationContext).validate(JsonElementValidatorItem.parseJson(this.permissiveMode, receivedJsonText, controlJsonText));
        logger.info("JSON message validation successful: All values OK");
    }

    protected Class<JsonMessageValidationContext> getRequiredValidationContextType() {
        return JsonMessageValidationContext.class;
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.JSON.name()) && MessageUtils.hasJsonPayload((Message)message);
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public JsonTextMessageValidator strict(boolean strict) {
        this.setStrict(strict);
        return this;
    }

    void setJsonSchemaValidation(JsonSchemaValidation jsonSchemaValidation) {
        this.jsonSchemaValidation = jsonSchemaValidation;
    }

    public JsonTextMessageValidator jsonSchemaValidation(JsonSchemaValidation jsonSchemaValidation) {
        this.setJsonSchemaValidation(jsonSchemaValidation);
        return this;
    }

    public void setElementValidatorProvider(JsonElementValidator.Provider elementValidatorProvider) {
        this.elementValidatorProvider = elementValidatorProvider;
    }

    public JsonTextMessageValidator elementValidatorProvider(JsonElementValidator.Provider elementValidatorProvider) {
        this.setElementValidatorProvider(elementValidatorProvider);
        return this;
    }

    public void setPermissiveMode(int permissiveMode) {
        this.permissiveMode = permissiveMode;
    }

    public JsonTextMessageValidator permissiveMode(int permissiveMode) {
        this.setPermissiveMode(permissiveMode);
        return this;
    }
}

