/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class JsonPathFunctions {
    private static final String[] FUNCTION_NAMES = new String[]{"keySet", "size", "values", "toString", "exists"};

    public static Object evaluate(Object jsonPathResult, String jsonPathFunction) {
        switch (jsonPathFunction) {
            case "exists": {
                return jsonPathResult != null;
            }
            case "size": {
                if (jsonPathResult instanceof JSONArray) {
                    return ((JSONArray)jsonPathResult).size();
                }
                if (jsonPathResult instanceof JSONObject) {
                    return ((JSONObject)jsonPathResult).size();
                }
                return jsonPathResult != null ? 1 : 0;
            }
            case "keySet": {
                if (jsonPathResult instanceof JSONObject) {
                    return ((JSONObject)jsonPathResult).keySet();
                }
                return Collections.emptySet();
            }
            case "values": {
                if (jsonPathResult instanceof JSONObject) {
                    Object[] valueObjects = ((JSONObject)jsonPathResult).values().toArray();
                    ArrayList<String> values = new ArrayList<String>(valueObjects.length);
                    for (Object value : valueObjects) {
                        if (value instanceof JSONObject) {
                            values.add(((JSONObject)value).toJSONString());
                            continue;
                        }
                        if (value instanceof JSONArray) {
                            values.add(((JSONArray)value).toJSONString());
                            continue;
                        }
                        values.add(String.valueOf(value));
                    }
                    return ((Object)values).toString();
                }
                return new Object[0];
            }
            case "toString": {
                if (jsonPathResult instanceof JSONArray) {
                    return ((JSONArray)jsonPathResult).toJSONString();
                }
                if (jsonPathResult instanceof JSONObject) {
                    return ((JSONObject)jsonPathResult).toJSONString();
                }
                return jsonPathResult.toString();
            }
        }
        return jsonPathResult;
    }

    public static String[] getSupportedFunctions() {
        return Arrays.copyOf(FUNCTION_NAMES, FUNCTION_NAMES.length);
    }
}

