/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.json;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.json.schema.SimpleJsonSchema;
import org.citrusframework.repository.BaseRepository;
import org.citrusframework.spi.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaRepository
extends BaseRepository {
    private static Logger logger = LoggerFactory.getLogger(JsonSchemaRepository.class);
    private static final String DEFAULT_NAME = "jsonSchemaRepository";
    private List<SimpleJsonSchema> schemas = new ArrayList<SimpleJsonSchema>();

    public JsonSchemaRepository() {
        super(DEFAULT_NAME);
    }

    protected void addRepository(Resource resource) {
        if (resource.getLocation().endsWith(".json")) {
            if (logger.isDebugEnabled()) {
                logger.debug("Loading json schema resource '{}'", (Object)resource.getLocation());
            }
            SimpleJsonSchema simpleJsonSchema = new SimpleJsonSchema(resource);
            simpleJsonSchema.initialize();
            this.schemas.add(simpleJsonSchema);
        } else {
            logger.warn("Skipped resource other than json schema for repository '{}'", (Object)resource.getLocation());
        }
    }

    public List<SimpleJsonSchema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<SimpleJsonSchema> schemas) {
        this.schemas = schemas;
    }

    public static Logger getLog() {
        return logger;
    }

    public static void setLog(Logger logger) {
        JsonSchemaRepository.logger = logger;
    }

    public void addSchema(SimpleJsonSchema simpleJsonSchema) {
        this.schemas.add(simpleJsonSchema);
    }
}

