/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.ValidationUtils;
import org.citrusframework.validation.context.MessageValidationContext;
import org.citrusframework.validation.json.JsonElementValidatorItem;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;

public class JsonElementValidator {
    private final boolean strict;
    private final TestContext context;
    private final Collection<String> ignoreExpressions;

    public JsonElementValidator(boolean strict, TestContext context, Collection<String> ignoreExpressions) {
        this.strict = strict;
        this.context = context;
        this.ignoreExpressions = ignoreExpressions;
    }

    public void validate(JsonElementValidatorItem<?> control) {
        if (JsonElementValidator.isIgnoredByPlaceholderOrExpressionList(this.ignoreExpressions, control)) {
            return;
        }
        if (ValidationMatcherUtils.isValidationMatcherExpression((String)Objects.requireNonNullElse(control.expectedAsStringOrNull(), ""))) {
            ValidationMatcherUtils.resolveValidationMatcher((String)control.getJsonPath(), (String)control.actualAsStringOrNull(), (String)control.expectedAsStringOrNull(), (TestContext)this.context);
        } else if (control.expected instanceof JSONObject) {
            this.validateJSONObject(this, control);
        } else if (control.expected instanceof JSONArray) {
            this.validateJSONArray(this, control);
        } else {
            JsonElementValidator.validateNativeType(control);
        }
    }

    private void validateJSONObject(JsonElementValidator validator, JsonElementValidatorItem<?> control) {
        JsonElementValidatorItem<JSONObject> objectControl = control.ensureType(JSONObject.class);
        if (this.strict) {
            this.validateSameSize(objectControl.getJsonPath(), ((JSONObject)objectControl.expected).keySet(), ((JSONObject)objectControl.actual).keySet());
        }
        List<JsonElementValidatorItem> controlEntries = ((JSONObject)objectControl.expected).entrySet().stream().map(entry -> new JsonElementValidatorItem<Object>((String)entry.getKey(), ((JSONObject)objectControl.actual).get(entry.getKey()), entry.getValue()).parent(objectControl)).toList();
        for (JsonElementValidatorItem entryControl : controlEntries) {
            if (!((JSONObject)objectControl.actual).containsKey((Object)entryControl.getName())) {
                throw new ValidationException(ValidationUtils.buildValueToBeInCollectionErrorMessage((String)"Missing JSON entry", (Object)entryControl.getName(), (Collection)((JSONObject)objectControl.actual).keySet()));
            }
            validator.validate(entryControl);
        }
    }

    static boolean isIgnoredByPlaceholderOrExpressionList(Collection<String> ignoreExpressions, JsonElementValidatorItem<?> controlEntry) {
        String trimmedControlValue = Objects.requireNonNullElse(controlEntry.expectedAsStringOrNull(), "").trim();
        if (trimmedControlValue.equals("@ignore@")) {
            return true;
        }
        return ignoreExpressions.stream().anyMatch(controlEntry::isPathIgnoredBy);
    }

    private void validateJSONArray(JsonElementValidator validator, JsonElementValidatorItem<?> control) {
        JsonElementValidatorItem<JSONArray> arrayControl = control.ensureType(JSONArray.class);
        if (this.strict) {
            this.validateSameSize(control.getJsonPath(), (Collection)arrayControl.expected, (Collection)arrayControl.actual);
        }
        ArrayList remaining = new ArrayList(((JSONArray)arrayControl.actual).size());
        ((JSONArray)arrayControl.actual).iterator().forEachRemaining(remaining::add);
        for (int i = 0; i < ((JSONArray)arrayControl.expected).size(); ++i) {
            if (JsonElementValidator.isIgnoredByPlaceholderOrExpressionList(this.ignoreExpressions, arrayControl.child(i, i, ((JSONArray)arrayControl.expected).get(i)).parent(arrayControl))) continue;
            if (remaining.isEmpty()) {
                JsonElementValidator.throwValueMismatch("Missing entries in array element: '" + control.getName() + "'", ((JSONArray)arrayControl.expected).size(), ((JSONArray)arrayControl.actual).size());
            }
            boolean isValid = false;
            for (int actualIndex = 0; !isValid && actualIndex < remaining.size(); ++actualIndex) {
                JsonElementValidatorItem<Object> item = arrayControl.child(i, remaining.get(actualIndex), ((JSONArray)arrayControl.expected).get(i)).parent(arrayControl);
                if (!JsonElementValidator.isValidItem(item, validator)) continue;
                isValid = true;
                remaining.remove(actualIndex);
            }
            if (isValid) continue;
            throw new ValidationException(ValidationUtils.buildValueToBeInCollectionErrorMessage((String)"An item in '%s' is missing".formatted(arrayControl.getJsonPath()), (Object)((JSONArray)arrayControl.expected).get(i), (Collection)((Collection)arrayControl.actual)));
        }
    }

    private static boolean isValidItem(JsonElementValidatorItem<Object> validatorItem, JsonElementValidator validator) {
        try {
            validator.validate(validatorItem);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    private void validateSameSize(String path, Collection<?> expected, Collection<?> actual) {
        if (expected.size() != actual.size()) {
            JsonElementValidator.throwValueMismatch("Number of entries is not equal in element: '" + path + "'", expected, actual);
        }
    }

    private static void validateNativeType(JsonElementValidatorItem<?> control) {
        if (!Objects.equals(control.expected, control.actual)) {
            JsonElementValidator.throwValueMismatch("Values not equal for entry: '" + control.getJsonPath() + "'", control.expected, control.actual);
        }
    }

    private static void throwValueMismatch(String baseMessage, Object expectedValue, Object actualValue) {
        throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage((String)baseMessage, (Object)expectedValue, (Object)actualValue));
    }

    @FunctionalInterface
    public static interface Provider {
        public static final Provider DEFAULT = (isStrict, context, validationContext) -> new JsonElementValidator(isStrict, context, validationContext.getIgnoreExpressions());

        public JsonElementValidator getValidator(boolean var1, TestContext var2, MessageValidationContext var3);
    }
}

