/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.text;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageType;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.text.BinaryBase64MessageValidator;
import org.springframework.util.StreamUtils;

public class GzipBinaryBase64MessageValidator
extends BinaryBase64MessageValidator {
    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) throws ValidationException {
        if (receivedMessage.getPayload() instanceof byte[]) {
            try (GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)receivedMessage.getPayload(InputStream.class));
                 ByteArrayOutputStream unzipped = new ByteArrayOutputStream();){
                StreamUtils.copy((InputStream)gzipInputStream, (OutputStream)unzipped);
                receivedMessage.setPayload((Object)unzipped.toByteArray());
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to validate gzipped message", (Throwable)e);
            }
        }
        super.validateMessage(receivedMessage, controlMessage, context, validationContext);
    }

    @Override
    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.GZIP_BASE64.toString());
    }
}

