/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.text;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageType;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.DefaultMessageValidator;
import org.citrusframework.validation.context.MessageValidationContext;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;

public class PlainTextMessageValidator
extends DefaultMessageValidator {
    public static final String IGNORE_NEWLINE_TYPE_PROPERTY = "citrus.plaintext.validation.ignore.newline.type";
    public static final String IGNORE_NEWLINE_TYPE_ENV = "CITRUS_PLAINTEXT_VALIDATION_IGNORE_NEWLINE_TYPE";
    public static final String IGNORE_WHITESPACE_PROPERTY = "citrus.plaintext.validation.ignore.whitespace";
    public static final String IGNORE_WHITESPACE_ENV = "CITRUS_PLAINTEXT_VALIDATION_IGNORE_WHITESPACE";
    private boolean ignoreNewLineType = Boolean.parseBoolean(System.getProperty("citrus.plaintext.validation.ignore.newline.type", System.getenv("CITRUS_PLAINTEXT_VALIDATION_IGNORE_NEWLINE_TYPE") != null ? System.getenv("CITRUS_PLAINTEXT_VALIDATION_IGNORE_NEWLINE_TYPE") : "false"));
    private boolean ignoreWhitespace = Boolean.parseBoolean(System.getProperty("citrus.plaintext.validation.ignore.whitespace", System.getenv("CITRUS_PLAINTEXT_VALIDATION_IGNORE_WHITESPACE") != null ? System.getenv("CITRUS_PLAINTEXT_VALIDATION_IGNORE_WHITESPACE") : "false"));

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) throws ValidationException {
        if (controlMessage == null || controlMessage.getPayload() == null) {
            logger.debug("Skip message payload validation as no control message was defined");
            return;
        }
        logger.debug("Start text message validation");
        try {
            String resultValue = StringUtils.normalizeWhitespace((String)((String)receivedMessage.getPayload(String.class)).trim(), (boolean)this.ignoreWhitespace, (boolean)this.ignoreNewLineType);
            String controlValue = StringUtils.normalizeWhitespace((String)context.replaceDynamicContentInString(((String)controlMessage.getPayload(String.class)).trim()), (boolean)this.ignoreWhitespace, (boolean)this.ignoreNewLineType);
            controlValue = this.processIgnoreStatements(controlValue, resultValue);
            controlValue = this.processVariableStatements(controlValue, resultValue, context);
            if (ValidationMatcherUtils.isValidationMatcherExpression((String)controlValue)) {
                ValidationMatcherUtils.resolveValidationMatcher((String)"payload", (String)resultValue, (String)controlValue, (TestContext)context);
                return;
            }
            this.validateText(resultValue, controlValue);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Failed to validate text content", (Throwable)e);
        }
        logger.debug("Text validation successful: All values OK");
    }

    private String processIgnoreStatements(String control, String result) {
        if (control.equals("@ignore@")) {
            return control;
        }
        Pattern whitespacePattern = Pattern.compile("[\\W]");
        Pattern ignorePattern = Pattern.compile("@ignore\\(?(\\d*)\\)?@");
        Matcher ignoreMatcher = ignorePattern.matcher(control);
        while (ignoreMatcher.find()) {
            String actualValue;
            if (ignoreMatcher.groupCount() > 0 && StringUtils.hasText((String)ignoreMatcher.group(1))) {
                int end = ignoreMatcher.start() + Integer.parseInt(ignoreMatcher.group(1));
                if (end > result.length()) {
                    end = result.length();
                }
                actualValue = ignoreMatcher.start() > result.length() ? "" : result.substring(ignoreMatcher.start(), end);
            } else {
                actualValue = result.substring(ignoreMatcher.start());
                Matcher whitespaceMatcher = whitespacePattern.matcher(actualValue);
                if (whitespaceMatcher.find()) {
                    actualValue = actualValue.substring(0, whitespaceMatcher.start());
                }
            }
            control = ignoreMatcher.replaceFirst(actualValue);
            ignoreMatcher = ignorePattern.matcher(control);
        }
        return control;
    }

    private String processVariableStatements(String control, String result, TestContext context) {
        if (control.equals("@ignore@")) {
            return control;
        }
        Pattern whitespacePattern = Pattern.compile("[^a-zA-Z_0-9\\-\\.]");
        Pattern variablePattern = Pattern.compile("@variable\\(?'?([a-zA-Z_0-9\\-\\.]*)'?\\)?@");
        Matcher variableMatcher = variablePattern.matcher(control);
        while (variableMatcher.find()) {
            String actualValue = result.substring(variableMatcher.start());
            Matcher whitespaceMatcher = whitespacePattern.matcher(actualValue);
            if (whitespaceMatcher.find()) {
                actualValue = actualValue.substring(0, whitespaceMatcher.start());
            }
            control = variableMatcher.replaceFirst(actualValue);
            context.setVariable(variableMatcher.group(1), (Object)actualValue);
            variableMatcher = variablePattern.matcher(control);
        }
        return control;
    }

    private void validateText(String receivedMessagePayload, String controlMessagePayload) {
        if (!StringUtils.hasText((String)controlMessagePayload)) {
            logger.debug("Skip message payload validation as no control message was defined");
            return;
        }
        if (!StringUtils.hasText((String)receivedMessagePayload)) {
            throw new ValidationException("Validation failed - expected message contents, but received empty message!");
        }
        if (!receivedMessagePayload.equals(controlMessagePayload)) {
            if (receivedMessagePayload.replaceAll("\\s", "").equals(controlMessagePayload.replaceAll("\\s", ""))) {
                throw new ValidationException("Text values not equal (only whitespaces!), expected '" + controlMessagePayload + "' but was '" + receivedMessagePayload + "'");
            }
            throw new ValidationException("Text values not equal, expected '" + controlMessagePayload + "' but was '" + receivedMessagePayload + "'");
        }
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.PLAINTEXT.toString());
    }

    public ValidationContext findValidationContext(List<ValidationContext> validationContexts) {
        Optional<ValidationContext> messageValidationContext = validationContexts.stream().filter(MessageValidationContext.class::isInstance).findFirst();
        return messageValidationContext.orElseGet(() -> super.findValidationContext(validationContexts));
    }

    public boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
    }

    public boolean isIgnoreNewLineType() {
        return this.ignoreNewLineType;
    }

    public void setIgnoreNewLineType(boolean ignoreNewLineType) {
        this.ignoreNewLineType = ignoreNewLineType;
    }
}

