/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.UnknownElementException;
import org.citrusframework.message.Message;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.validation.xml.XmlNamespaceAware;
import org.citrusframework.variable.VariableExtractor;
import org.citrusframework.xml.xpath.XPathExpressionResult;
import org.citrusframework.xml.xpath.XPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XpathPayloadVariableExtractor
implements VariableExtractor {
    private final Map<String, Object> xPathExpressions;
    private final Map<String, String> namespaces;
    private static final Logger LOG = LoggerFactory.getLogger(XpathPayloadVariableExtractor.class);

    public XpathPayloadVariableExtractor() {
        this(new Builder());
    }

    private XpathPayloadVariableExtractor(Builder builder) {
        this.xPathExpressions = builder.expressions;
        this.namespaces = builder.namespaces;
    }

    public void extractVariables(Message message, TestContext context) {
        if (CollectionUtils.isEmpty(this.xPathExpressions)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading XML elements with XPath");
        }
        NamespaceContext nsContext = context.getNamespaceContextBuilder().buildContext(message, this.namespaces);
        for (Map.Entry<String, Object> entry : this.xPathExpressions.entrySet()) {
            String pathExpression = context.replaceDynamicContentInString(entry.getKey());
            String variableName = Optional.ofNullable(entry.getValue()).map(Object::toString).orElseThrow(() -> new CitrusRuntimeException(String.format("Variable name must be set on extractor path expression '%s'", pathExpression)));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evaluating XPath expression: " + pathExpression);
            }
            Document doc = XMLUtils.parseMessagePayload((String)message.getPayload(String.class));
            if (XPathUtils.isXPathExpression(pathExpression)) {
                XPathExpressionResult resultType = XPathExpressionResult.fromString(pathExpression, XPathExpressionResult.STRING);
                Object value = XPathUtils.evaluate(doc, XPathExpressionResult.cutOffPrefix(pathExpression), nsContext, resultType);
                if (value == null) {
                    throw new CitrusRuntimeException("Not able to find value for expression: " + XPathExpressionResult.cutOffPrefix(pathExpression));
                }
                if (value instanceof List) {
                    value = ((List)value).stream().collect(Collectors.joining(","));
                }
                context.setVariable(variableName, value);
                continue;
            }
            Node node = XMLUtils.findNodeByName(doc, pathExpression);
            if (node == null) {
                throw new UnknownElementException("No element found for expression" + pathExpression);
            }
            if (node.getNodeType() == 1) {
                if (node.getFirstChild() != null) {
                    context.setVariable(variableName, (Object)node.getFirstChild().getNodeValue());
                    continue;
                }
                context.setVariable(variableName, (Object)"");
                continue;
            }
            context.setVariable(variableName, (Object)node.getNodeValue());
        }
    }

    public Map<String, Object> getXpathExpressions() {
        return this.xPathExpressions;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public static final class Builder
    implements VariableExtractor.Builder<XpathPayloadVariableExtractor, Builder>,
    XmlNamespaceAware {
        private final Map<String, Object> expressions = new HashMap<String, Object>();
        private final Map<String, String> namespaces = new HashMap<String, String>();

        public Builder namespace(String prefix, String namespaceUri) {
            this.namespaces.put(prefix, namespaceUri);
            return this;
        }

        public Builder namespaces(Map<String, String> namespaceMappings) {
            this.namespaces.putAll(namespaceMappings);
            return this;
        }

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String expression, Object variableName) {
            this.expressions.put(expression, variableName);
            return this;
        }

        public void setNamespaces(Map<String, String> namespaces) {
            this.namespaces(namespaces);
        }

        public XpathPayloadVariableExtractor build() {
            return new XpathPayloadVariableExtractor(this);
        }
    }
}

