/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xml.schema;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.citrusframework.XmlValidationHelper;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.util.IsXmlPredicate;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.validation.SchemaValidator;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.citrusframework.xml.XsdSchemaRepository;
import org.citrusframework.xml.schema.WsdlXsdSchema;
import org.citrusframework.xml.schema.XsdSchemaCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class XmlSchemaValidation
implements SchemaValidator<XmlMessageValidationContext> {
    private Logger log = LoggerFactory.getLogger(XmlSchemaValidation.class);
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public void validate(Message message, TestContext context, XmlMessageValidationContext validationContext) {
        this.validateSchema(message, context, validationContext);
        this.validateDTD(validationContext.getDTDResource(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSchema(Message message, TestContext context, XmlMessageValidationContext validationContext) {
        if (message.getPayload() == null || !StringUtils.hasText((String)((String)message.getPayload(String.class)))) {
            return;
        }
        try {
            SAXParseException[] results;
            Document doc = XMLUtils.parseMessagePayload((String)message.getPayload(String.class));
            if (!StringUtils.hasText((String)doc.getFirstChild().getNamespaceURI())) {
                return;
            }
            this.log.debug("Starting XML schema validation ...");
            XmlValidator validator = null;
            XsdSchemaRepository schemaRepository = null;
            List<XsdSchemaRepository> schemaRepositories = XmlValidationHelper.getSchemaRepositories(context);
            if (validationContext.getSchema() != null) {
                validator = ((XsdSchema)context.getReferenceResolver().resolve(validationContext.getSchema(), XsdSchema.class)).createValidator();
            } else if (validationContext.getSchemaRepository() != null) {
                schemaRepository = (XsdSchemaRepository)context.getReferenceResolver().resolve(validationContext.getSchemaRepository(), XsdSchemaRepository.class);
            } else if (schemaRepositories.size() == 1) {
                schemaRepository = schemaRepositories.get(0);
            } else if (schemaRepositories.size() > 0) {
                schemaRepository = schemaRepositories.stream().filter(repository -> repository.canValidate(doc)).findFirst().orElseThrow(() -> new CitrusRuntimeException(String.format("Failed to find proper schema repository for validating element '%s(%s)'", doc.getFirstChild().getLocalName(), doc.getFirstChild().getNamespaceURI())));
            } else {
                this.log.warn("Neither schema instance nor schema repository defined - skipping XML schema validation");
                return;
            }
            if (schemaRepository != null) {
                if (!schemaRepository.canValidate(doc)) {
                    throw new CitrusRuntimeException(String.format("Unable to find proper XML schema definition for element '%s(%s)' in schema repository '%s'", doc.getFirstChild().getLocalName(), doc.getFirstChild().getNamespaceURI(), schemaRepository.getName()));
                }
                ArrayList<Object> schemas = new ArrayList<Object>();
                for (XsdSchema xsdSchema : schemaRepository.getSchemas()) {
                    if (xsdSchema instanceof XsdSchemaCollection) {
                        schemas.addAll(((XsdSchemaCollection)xsdSchema).getSchemaResources());
                        continue;
                    }
                    if (xsdSchema instanceof WsdlXsdSchema) {
                        schemas.addAll(((WsdlXsdSchema)xsdSchema).getSchemaResources());
                        continue;
                    }
                    TransformerFactory transformerFactory = this.transformerFactory;
                    synchronized (transformerFactory) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        try {
                            this.transformerFactory.newTransformer().transform(xsdSchema.getSource(), new StreamResult(bos));
                        }
                        catch (TransformerException e) {
                            throw new CitrusRuntimeException("Failed to read schema " + xsdSchema.getTargetNamespace(), (Throwable)e);
                        }
                        schemas.add(new ByteArrayResource(bos.toByteArray()));
                    }
                }
                validator = XmlValidatorFactory.createValidator((Resource[])schemas.toArray(new Resource[schemas.size()]), (String)"http://www.w3.org/2001/XMLSchema");
            }
            if ((results = validator.validate((Source)new DOMSource(doc))).length != 0) {
                this.log.error("XML schema validation failed for message:\n" + XMLUtils.prettyPrint((String)message.getPayload(String.class)));
                this.log.debug("Found " + results.length + " schema validation errors");
                StringBuilder errors = new StringBuilder();
                for (SAXParseException e : results) {
                    errors.append(e.toString());
                    errors.append("\n");
                }
                this.log.debug(errors.toString());
                throw new ValidationException("XML schema validation failed:", (Throwable)results[0]);
            }
            this.log.info("XML schema validation successful: All values OK");
        }
        catch (IOException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    protected void validateDTD(Resource dtdResource, Message receivedMessage) {
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return "XML".equals(messageType) || message != null && IsXmlPredicate.getInstance().test((String)message.getPayload(String.class));
    }
}

