/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.common.Named;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.xml.schema.TargetNamespaceSchemaMappingStrategy;
import org.citrusframework.xml.schema.WsdlXsdSchema;
import org.citrusframework.xml.schema.XsdSchemaMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.xml.xsd.SimpleXsdSchema;
import org.springframework.xml.xsd.XsdSchema;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XsdSchemaRepository
implements Named,
InitializingPhase {
    private String name = "schemaRepository";
    private List<XsdSchema> schemas = new ArrayList<XsdSchema>();
    private List<String> locations = new ArrayList<String>();
    private XsdSchemaMappingStrategy schemaMappingStrategy = new TargetNamespaceSchemaMappingStrategy();
    private static final Logger LOG = LoggerFactory.getLogger(XsdSchemaRepository.class);

    public boolean canValidate(Document doc) {
        XsdSchema schema = this.schemaMappingStrategy.getSchema(this.schemas, doc);
        return schema != null;
    }

    public void initialize() {
        try {
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            for (String location : this.locations) {
                Resource[] findings;
                for (Resource resource : findings = resourcePatternResolver.getResources(location)) {
                    this.addSchemas(resource);
                }
            }
            this.addCitrusSchema("citrus-http-message");
            this.addCitrusSchema("citrus-mail-message");
            this.addCitrusSchema("citrus-ftp-message");
            this.addCitrusSchema("citrus-ssh-message");
            this.addCitrusSchema("citrus-rmi-message");
            this.addCitrusSchema("citrus-jmx-message");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CitrusRuntimeException("Failed to initialize Xsd schema repository", (Throwable)e);
        }
    }

    protected void addCitrusSchema(String schemaName) throws IOException, SAXException, ParserConfigurationException {
        Resource resource = new PathMatchingResourcePatternResolver().getResource("classpath:org/citrusframework/schema/" + schemaName + ".xsd");
        if (resource.exists()) {
            this.addXsdSchema(resource);
        }
    }

    private void addSchemas(Resource resource) {
        if (resource.getFilename().endsWith(".xsd")) {
            this.addXsdSchema(resource);
        } else if (resource.getFilename().endsWith(".wsdl")) {
            this.addWsdlSchema(resource);
        } else {
            LOG.warn("Skipped resource other than XSD schema for repository (" + resource.getFilename() + ")");
        }
    }

    private void addWsdlSchema(Resource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading WSDL schema resource " + resource.getFilename());
        }
        WsdlXsdSchema wsdl = new WsdlXsdSchema(resource);
        wsdl.initialize();
        this.schemas.add((XsdSchema)wsdl);
    }

    private void addXsdSchema(Resource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading XSD schema resource " + resource.getFilename());
        }
        SimpleXsdSchema schema = new SimpleXsdSchema(resource);
        try {
            schema.afterPropertiesSet();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CitrusRuntimeException("Failed to initialize xsd schema", (Throwable)e);
        }
        this.schemas.add((XsdSchema)schema);
    }

    public List<XsdSchema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<XsdSchema> schemas) {
        this.schemas = schemas;
    }

    public void setSchemaMappingStrategy(XsdSchemaMappingStrategy schemaMappingStrategy) {
        this.schemaMappingStrategy = schemaMappingStrategy;
    }

    public XsdSchemaMappingStrategy getSchemaMappingStrategy() {
        return this.schemaMappingStrategy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }
}

