/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml.schema;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.SimpleXsdSchema;
import org.xml.sax.SAXException;

public abstract class AbstractSchemaCollection
extends SimpleXsdSchema
implements InitializingPhase {
    protected List<Resource> schemaResources = new ArrayList<Resource>();
    protected List<String> importedSchemas = new ArrayList<String>();
    public static final String WWW_W3_ORG_2000_XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String W3C_XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";

    public XmlValidator createValidator() {
        try {
            return XmlValidatorFactory.createValidator((Resource[])this.schemaResources.toArray(new Resource[this.schemaResources.size()]), (String)W3C_XML_SCHEMA_NS_URI);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create validator from multi resource schema files", (Throwable)e);
        }
    }

    protected void addImportedSchemas(Schema schema) throws WSDLException, IOException, TransformerException, TransformerFactoryConfigurationError {
        for (Object imports : schema.getImports().values()) {
            for (SchemaImport schemaImport : (Vector)imports) {
                if (this.importedSchemas.contains(schemaImport.getNamespaceURI())) continue;
                this.importedSchemas.add(schemaImport.getNamespaceURI());
                Schema referencedSchema = schemaImport.getReferencedSchema();
                if (referencedSchema == null) continue;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DOMSource source = new DOMSource(referencedSchema.getElement());
                StreamResult result = new StreamResult(bos);
                TransformerFactory.newInstance().newTransformer().transform(source, result);
                ByteArrayResource schemaResource = new ByteArrayResource(bos.toByteArray());
                this.addImportedSchemas(referencedSchema);
                this.schemaResources.add((Resource)schemaResource);
            }
        }
    }

    protected void addIncludedSchemas(Schema schema) throws WSDLException, IOException, TransformerException, TransformerFactoryConfigurationError {
        List includes = schema.getIncludes();
        for (SchemaReference schemaReference : includes) {
            URI locationURI = URI.create(schemaReference.getSchemaLocationURI());
            Object schemaLocation = locationURI.isAbsolute() ? schemaReference.getSchemaLocationURI() : schema.getDocumentBaseURI().substring(0, schema.getDocumentBaseURI().lastIndexOf(47) + 1) + schemaReference.getSchemaLocationURI();
            this.schemaResources.add((Resource)new FileSystemResource((String)schemaLocation));
        }
    }

    public void initialize() {
        Resource targetXsd = this.loadSchemaResources();
        if (targetXsd == null) {
            throw new CitrusRuntimeException("Failed to find target schema xsd file resource");
        }
        Assert.isTrue((!this.schemaResources.isEmpty() ? 1 : 0) != 0, (String)"At least one schema xsd file resource is required");
        this.setXsd(targetXsd);
        try {
            super.afterPropertiesSet();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CitrusRuntimeException("Failed to initialize schema collection", (Throwable)e);
        }
    }

    protected abstract Resource loadSchemaResources();

    public List<Resource> getSchemaResources() {
        return this.schemaResources;
    }
}

