/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml.schema;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.xml.schema.AbstractSchemaMappingStrategy;
import org.springframework.util.StringUtils;
import org.springframework.xml.xsd.XsdSchema;

public class RootQNameSchemaMappingStrategy
extends AbstractSchemaMappingStrategy {
    private Map<String, XsdSchema> mappings;

    @Override
    public XsdSchema getSchema(List<XsdSchema> schemas, String namespace, String elementName) {
        XsdSchema schema = null;
        QName rootQName = new QName(namespace, elementName, "");
        if (this.mappings.containsKey(rootQName.toString())) {
            schema = this.mappings.get(rootQName.toString());
        } else if (this.mappings.containsKey(elementName)) {
            schema = this.mappings.get(elementName);
        }
        if (!(schema == null || StringUtils.hasText((String)schema.getTargetNamespace()) && schema.getTargetNamespace().equals(namespace))) {
            throw new CitrusRuntimeException("Schema target namespace inconsitency for located XSD schema definition (" + schema.getTargetNamespace() + ")");
        }
        return schema;
    }

    public void setMappings(Map<String, XsdSchema> mappings) {
        this.mappings = mappings;
    }
}

