/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.selector;

import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageSelector;
import org.citrusframework.message.selector.AbstractMessageSelector;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.xml.xpath.XPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.springframework.xml.xpath.XPathParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;

public class XpathPayloadMessageSelector
extends AbstractMessageSelector {
    public static final String SELECTOR_PREFIX = "xpath:";
    private static Logger log = LoggerFactory.getLogger(XpathPayloadMessageSelector.class);

    public XpathPayloadMessageSelector(String selectKey, String matchingValue, TestContext context) {
        super(selectKey.substring(SELECTOR_PREFIX.length()), matchingValue, context);
    }

    public boolean accept(Message message) {
        Document doc;
        try {
            doc = XMLUtils.parseMessagePayload(this.getPayloadAsString(message));
        }
        catch (LSException e) {
            log.warn("Ignoring non XML message for XPath message selector (" + e.getClass().getName() + ")");
            return false;
        }
        try {
            String value;
            Map<String, String> namespaces = XMLUtils.lookupNamespaces(doc);
            namespaces.putAll(this.context.getNamespaceContextBuilder().getNamespaceMappings());
            if (XPathUtils.hasDynamicNamespaces(this.selectKey)) {
                namespaces.putAll(XPathUtils.getDynamicNamespaces(this.selectKey));
                value = XPathExpressionFactory.createXPathExpression((String)XPathUtils.replaceDynamicNamespaces(this.selectKey, namespaces), namespaces).evaluateAsString((Node)doc);
            } else {
                value = XPathExpressionFactory.createXPathExpression((String)this.selectKey, namespaces).evaluateAsString((Node)doc);
            }
            return this.evaluate(value);
        }
        catch (XPathParseException e) {
            log.warn("Could not evaluate XPath expression for message selector - ignoring message (" + ((Object)((Object)e)).getClass().getName() + ")");
            return false;
        }
    }

    public static class Factory
    implements MessageSelector.MessageSelectorFactory {
        public boolean supports(String key) {
            return key.startsWith(XpathPayloadMessageSelector.SELECTOR_PREFIX);
        }

        public XpathPayloadMessageSelector create(String key, String value, TestContext context) {
            return new XpathPayloadMessageSelector(key, value, context);
        }
    }
}

