/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xml;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.citrusframework.XmlValidationHelper;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageType;
import org.citrusframework.util.MessageUtils;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.validation.AbstractMessageValidator;
import org.citrusframework.validation.ValidationUtils;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.citrusframework.validation.xml.XmlValidationUtils;
import org.citrusframework.validation.xml.schema.XmlSchemaValidation;
import org.citrusframework.xml.namespace.NamespaceContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;

public class DomXmlMessageValidator
extends AbstractMessageValidator<XmlMessageValidationContext> {
    private static final Logger LOG = LoggerFactory.getLogger(DomXmlMessageValidator.class);
    private NamespaceContextBuilder namespaceContextBuilder;
    private XmlSchemaValidation schemaValidator = new XmlSchemaValidation();

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, XmlMessageValidationContext validationContext) throws ValidationException {
        LOG.debug("Start XML message validation ...");
        try {
            if (validationContext.isSchemaValidationEnabled()) {
                this.schemaValidator.validate(receivedMessage, context, validationContext);
            }
            this.validateNamespaces(validationContext.getControlNamespaces(), receivedMessage);
            this.validateMessageContent(receivedMessage, controlMessage, validationContext, context);
            if (controlMessage != null) {
                Assert.isTrue((controlMessage.getHeaderData().size() <= receivedMessage.getHeaderData().size() ? 1 : 0) != 0, (String)("Failed to validate header data XML fragments - found " + receivedMessage.getHeaderData().size() + " header fragments, expected " + controlMessage.getHeaderData().size()));
                for (int i = 0; i < controlMessage.getHeaderData().size(); ++i) {
                    this.validateXmlHeaderFragment((String)receivedMessage.getHeaderData().get(i), (String)controlMessage.getHeaderData().get(i), validationContext, context);
                }
            }
            LOG.info("XML message validation successful: All values OK");
        }
        catch (ClassCastException | DOMException | LSException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Failed to validate:\n" + XMLUtils.prettyPrint((String)receivedMessage.getPayload(String.class)));
            throw new ValidationException("Validation failed:", (Throwable)e);
        }
        catch (ValidationException ex) {
            LOG.error("Failed to validate:\n" + XMLUtils.prettyPrint((String)receivedMessage.getPayload(String.class)));
            throw ex;
        }
    }

    protected void validateNamespaces(Map<String, String> expectedNamespaces, Message receivedMessage) {
        if (CollectionUtils.isEmpty(expectedNamespaces)) {
            return;
        }
        if (receivedMessage.getPayload() == null || !StringUtils.hasText((String)((String)receivedMessage.getPayload(String.class)))) {
            throw new ValidationException("Unable to validate message namespaces - receive message payload was empty");
        }
        LOG.debug("Start XML namespace validation");
        Document received = XMLUtils.parseMessagePayload((String)receivedMessage.getPayload(String.class));
        Map foundNamespaces = NamespaceContextBuilder.lookupNamespaces((String)((String)receivedMessage.getPayload(String.class)));
        if (foundNamespaces.size() != expectedNamespaces.size()) {
            throw new ValidationException("Number of namespace declarations not equal for node " + XMLUtils.getNodesPathName(received.getFirstChild()) + " found " + foundNamespaces.size() + " expected " + expectedNamespaces.size());
        }
        for (Map.Entry<String, String> entry : expectedNamespaces.entrySet()) {
            String namespace = entry.getKey();
            String url = entry.getValue();
            if (foundNamespaces.containsKey(namespace)) {
                if (!((String)foundNamespaces.get(namespace)).equals(url)) {
                    throw new ValidationException("Namespace '" + namespace + "' values not equal: found '" + (String)foundNamespaces.get(namespace) + "' expected '" + url + "' in reference node " + XMLUtils.getNodesPathName(received.getFirstChild()));
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Validating namespace " + namespace + " value as expected " + url + " - value OK");
                continue;
            }
            throw new ValidationException("Missing namespace " + namespace + "(" + url + ") in node " + XMLUtils.getNodesPathName(received.getFirstChild()));
        }
        LOG.info("XML namespace validation successful: All values OK");
    }

    private void doElementNameValidation(Node received, Node source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating element: " + received.getLocalName() + " (" + received.getNamespaceURI() + ")");
        }
        Assert.isTrue((boolean)received.getLocalName().equals(source.getLocalName()), (String)ValidationUtils.buildValueMismatchErrorMessage((String)"Element names not equal", (Object)source.getLocalName(), (Object)received.getLocalName()));
    }

    private void doElementNamespaceValidation(Node received, Node source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating namespace for element: " + received.getLocalName());
        }
        if (received.getNamespaceURI() != null) {
            Assert.isTrue((source.getNamespaceURI() != null ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Element namespace not equal for element '" + received.getLocalName() + "'"), null, (Object)received.getNamespaceURI()));
            Assert.isTrue((boolean)received.getNamespaceURI().equals(source.getNamespaceURI()), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Element namespace not equal for element '" + received.getLocalName() + "'"), (Object)source.getNamespaceURI(), (Object)received.getNamespaceURI()));
        } else {
            Assert.isTrue((source.getNamespaceURI() == null ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Element namespace not equal for element '" + received.getLocalName() + "'"), (Object)source.getNamespaceURI(), null));
        }
    }

    protected void validateMessageContent(Message receivedMessage, Message controlMessage, XmlMessageValidationContext validationContext, TestContext context) {
        if (controlMessage == null || controlMessage.getPayload() == null) {
            LOG.debug("Skip message payload validation as no control message was defined");
            return;
        }
        if (!(controlMessage.getPayload() instanceof String)) {
            throw new IllegalArgumentException("DomXmlMessageValidator does only support message payload of type String, but was " + controlMessage.getPayload().getClass());
        }
        String controlMessagePayload = (String)controlMessage.getPayload(String.class);
        if (receivedMessage.getPayload() == null || !StringUtils.hasText((String)((String)receivedMessage.getPayload(String.class)))) {
            Assert.isTrue((!StringUtils.hasText((String)controlMessagePayload) ? 1 : 0) != 0, (String)"Unable to validate message payload - received message payload was empty, control message payload is not");
            return;
        }
        if (!StringUtils.hasText((String)controlMessagePayload)) {
            LOG.debug("Skip message payload validation as no control message payload was defined");
            return;
        }
        LOG.debug("Start XML tree validation ...");
        Document received = XMLUtils.parseMessagePayload((String)receivedMessage.getPayload(String.class));
        Document source = XMLUtils.parseMessagePayload(controlMessagePayload);
        XMLUtils.stripWhitespaceNodes(received);
        XMLUtils.stripWhitespaceNodes(source);
        this.validateXmlTree(received, source, validationContext, this.getNamespaceContextBuilder(context).buildContext(receivedMessage, validationContext.getNamespaces()), context);
    }

    private void validateXmlHeaderFragment(String receivedHeaderData, String controlHeaderData, XmlMessageValidationContext validationContext, TestContext context) {
        LOG.debug("Start XML header data validation ...");
        Document received = XMLUtils.parseMessagePayload(receivedHeaderData);
        Document source = XMLUtils.parseMessagePayload(controlHeaderData);
        XMLUtils.stripWhitespaceNodes(received);
        XMLUtils.stripWhitespaceNodes(source);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received header data:\n" + XMLUtils.serialize(received));
            LOG.debug("Control header data:\n" + XMLUtils.serialize(source));
        }
        this.validateXmlTree(received, source, validationContext, this.getNamespaceContextBuilder(context).buildContext((Message)new DefaultMessage((Object)receivedHeaderData), validationContext.getNamespaces()), context);
    }

    private void validateXmlTree(Node received, Node source, XmlMessageValidationContext validationContext, NamespaceContext namespaceContext, TestContext context) {
        switch (received.getNodeType()) {
            case 10: {
                this.doDocumentTypeDefinition(received, source, validationContext, namespaceContext, context);
                break;
            }
            case 9: {
                this.validateXmlTree(received.getFirstChild(), source.getFirstChild(), validationContext, namespaceContext, context);
                break;
            }
            case 1: {
                this.doElement(received, source, validationContext, namespaceContext, context);
                break;
            }
            case 2: {
                throw new IllegalStateException();
            }
            case 8: {
                this.validateXmlTree(received.getNextSibling(), source, validationContext, namespaceContext, context);
                break;
            }
            case 7: {
                this.doPI(received);
            }
        }
    }

    private void doDocumentTypeDefinition(Node received, Node source, XmlMessageValidationContext validationContext, NamespaceContext namespaceContext, TestContext context) {
        Assert.isTrue((boolean)(source instanceof DocumentType), (String)"Missing document type definition in expected xml fragment");
        DocumentType receivedDTD = (DocumentType)received;
        DocumentType sourceDTD = (DocumentType)source;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating document type definition: " + receivedDTD.getPublicId() + " (" + receivedDTD.getSystemId() + ")");
        }
        if (!StringUtils.hasText((String)sourceDTD.getPublicId())) {
            Assert.isNull((Object)receivedDTD.getPublicId(), (String)ValidationUtils.buildValueMismatchErrorMessage((String)"Document type public id not equal", (Object)sourceDTD.getPublicId(), (Object)receivedDTD.getPublicId()));
        } else if (sourceDTD.getPublicId().trim().equals("@ignore@")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Document type public id: '" + receivedDTD.getPublicId() + "' is ignored by placeholder '@ignore@'");
            }
        } else {
            Assert.isTrue((StringUtils.hasText((String)receivedDTD.getPublicId()) && receivedDTD.getPublicId().equals(sourceDTD.getPublicId()) ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)"Document type public id not equal", (Object)sourceDTD.getPublicId(), (Object)receivedDTD.getPublicId()));
        }
        if (!StringUtils.hasText((String)sourceDTD.getSystemId())) {
            Assert.isNull((Object)receivedDTD.getSystemId(), (String)ValidationUtils.buildValueMismatchErrorMessage((String)"Document type system id not equal", (Object)sourceDTD.getSystemId(), (Object)receivedDTD.getSystemId()));
        } else if (sourceDTD.getSystemId().trim().equals("@ignore@")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Document type system id: '" + receivedDTD.getSystemId() + "' is ignored by placeholder '@ignore@'");
            }
        } else {
            Assert.isTrue((StringUtils.hasText((String)receivedDTD.getSystemId()) && receivedDTD.getSystemId().equals(sourceDTD.getSystemId()) ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)"Document type system id not equal", (Object)sourceDTD.getSystemId(), (Object)receivedDTD.getSystemId()));
        }
        this.validateXmlTree(received.getNextSibling(), source.getNextSibling(), validationContext, namespaceContext, context);
    }

    private void doElement(Node received, Node source, XmlMessageValidationContext validationContext, NamespaceContext namespaceContext, TestContext context) {
        this.doElementNameValidation(received, source);
        this.doElementNamespaceValidation(received, source);
        if (XmlValidationUtils.isElementIgnored(source, received, validationContext.getIgnoreExpressions(), namespaceContext)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating attributes for element: " + received.getLocalName());
        }
        NamedNodeMap receivedAttr = received.getAttributes();
        NamedNodeMap sourceAttr = source.getAttributes();
        Assert.isTrue((this.countAttributes(receivedAttr) == this.countAttributes(sourceAttr) ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Number of attributes not equal for element '" + received.getLocalName() + "'"), (Object)this.countAttributes(sourceAttr), (Object)this.countAttributes(receivedAttr)));
        for (int i = 0; i < receivedAttr.getLength(); ++i) {
            this.doAttribute(received, receivedAttr.item(i), source, validationContext, namespaceContext, context);
        }
        if (this.isValidationMatcherExpression(source)) {
            ValidationMatcherUtils.resolveValidationMatcher((String)source.getNodeName(), (String)received.getFirstChild().getNodeValue().trim(), (String)source.getFirstChild().getNodeValue().trim(), (TestContext)context);
            return;
        }
        this.doText((Element)received, (Element)source);
        List receivedChildElements = DomUtils.getChildElements((Element)((Element)received));
        List sourceChildElements = DomUtils.getChildElements((Element)((Element)source));
        Assert.isTrue((receivedChildElements.size() == sourceChildElements.size() ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Number of child elements not equal for element '" + received.getLocalName() + "'"), (Object)sourceChildElements.size(), (Object)receivedChildElements.size()));
        for (int i = 0; i < receivedChildElements.size(); ++i) {
            this.validateXmlTree((Node)receivedChildElements.get(i), (Node)sourceChildElements.get(i), validationContext, namespaceContext, context);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validation successful for element: " + received.getLocalName() + " (" + received.getNamespaceURI() + ")");
        }
    }

    private void doText(Element received, Element source) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating node value for element: " + received.getLocalName());
        }
        String receivedText = DomUtils.getTextValue((Element)received);
        String sourceText = DomUtils.getTextValue((Element)source);
        if (receivedText != null) {
            Assert.isTrue((sourceText != null ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Node value not equal for element '" + received.getLocalName() + "'"), null, (Object)receivedText.trim()));
            Assert.isTrue((boolean)receivedText.trim().equals(sourceText.trim()), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Node value not equal for element '" + received.getLocalName() + "'"), (Object)sourceText.trim(), (Object)receivedText.trim()));
        } else {
            Assert.isTrue((sourceText == null ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Node value not equal for element '" + received.getLocalName() + "'"), (Object)sourceText.trim(), null));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node value '" + receivedText.trim() + "': OK");
        }
    }

    private void doAttribute(Node receivedElement, Node receivedAttribute, Node sourceElement, XmlMessageValidationContext validationContext, NamespaceContext namespaceContext, TestContext context) {
        NamedNodeMap sourceAttributes;
        Node sourceAttribute;
        if (receivedAttribute.getNodeName().startsWith("xmlns")) {
            return;
        }
        String receivedAttributeName = receivedAttribute.getLocalName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating attribute: " + receivedAttributeName + " (" + receivedAttribute.getNamespaceURI() + ")");
        }
        Assert.isTrue(((sourceAttribute = (sourceAttributes = sourceElement.getAttributes()).getNamedItemNS(receivedAttribute.getNamespaceURI(), receivedAttributeName)) != null ? 1 : 0) != 0, (String)("Attribute validation failed for element '" + receivedElement.getLocalName() + "', unknown attribute " + receivedAttributeName + " (" + receivedAttribute.getNamespaceURI() + ")"));
        if (XmlValidationUtils.isAttributeIgnored(receivedElement, receivedAttribute, sourceAttribute, validationContext.getIgnoreExpressions(), namespaceContext)) {
            return;
        }
        String receivedValue = receivedAttribute.getNodeValue();
        String sourceValue = sourceAttribute.getNodeValue();
        if (this.isValidationMatcherExpression(sourceAttribute)) {
            ValidationMatcherUtils.resolveValidationMatcher((String)sourceAttribute.getNodeName(), (String)receivedAttribute.getNodeValue().trim(), (String)sourceAttribute.getNodeValue().trim(), (TestContext)context);
        } else if (receivedValue.contains(":") && sourceValue.contains(":")) {
            this.doNamespaceQualifiedAttributeValidation(receivedElement, receivedAttribute, sourceElement, sourceAttribute);
        } else {
            Assert.isTrue((boolean)receivedValue.equals(sourceValue), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for attribute '" + receivedAttributeName + "'"), (Object)sourceValue, (Object)receivedValue));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attribute '" + receivedAttributeName + "'='" + receivedValue + "': OK");
        }
    }

    private void doNamespaceQualifiedAttributeValidation(Node receivedElement, Node receivedAttribute, Node sourceElement, Node sourceAttribute) {
        String receivedValue = receivedAttribute.getNodeValue();
        String sourceValue = sourceAttribute.getNodeValue();
        if (receivedValue.contains(":") && sourceValue.contains(":")) {
            String receivedPrefix = receivedValue.substring(0, receivedValue.indexOf(58));
            String sourcePrefix = sourceValue.substring(0, sourceValue.indexOf(58));
            Map<String, String> receivedNamespaces = XMLUtils.lookupNamespaces(receivedAttribute.getOwnerDocument());
            receivedNamespaces.putAll(XMLUtils.lookupNamespaces(receivedElement));
            if (receivedNamespaces.containsKey(receivedPrefix)) {
                Map<String, String> sourceNamespaces = XMLUtils.lookupNamespaces(sourceAttribute.getOwnerDocument());
                sourceNamespaces.putAll(XMLUtils.lookupNamespaces(sourceElement));
                if (sourceNamespaces.containsKey(sourcePrefix)) {
                    Assert.isTrue((boolean)sourceNamespaces.get(sourcePrefix).equals(receivedNamespaces.get(receivedPrefix)), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for attribute value namespace '" + receivedValue + "'"), (Object)sourceNamespaces.get(sourcePrefix), (Object)receivedNamespaces.get(receivedPrefix)));
                    receivedValue = receivedValue.substring((receivedPrefix + ":").length());
                    sourceValue = sourceValue.substring((sourcePrefix + ":").length());
                } else {
                    throw new ValidationException("Received attribute value '" + receivedAttribute.getLocalName() + "' describes namespace qualified attribute value, control value '" + sourceValue + "' does not");
                }
            }
        }
        Assert.isTrue((boolean)receivedValue.equals(sourceValue), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for attribute '" + receivedAttribute.getLocalName() + "'"), (Object)sourceValue, (Object)receivedValue));
    }

    private void doPI(Node received) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignored processing instruction (" + received.getLocalName() + "=" + received.getNodeValue() + ")");
        }
    }

    private int countAttributes(NamedNodeMap attributesR) {
        int cntAttributes = 0;
        for (int i = 0; i < attributesR.getLength(); ++i) {
            if (attributesR.item(i).getNodeName().startsWith("xmlns")) continue;
            ++cntAttributes;
        }
        return cntAttributes;
    }

    private boolean isValidationMatcherExpression(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return node.getFirstChild() != null && StringUtils.hasText((String)node.getFirstChild().getNodeValue()) && ValidationMatcherUtils.isValidationMatcherExpression((String)node.getFirstChild().getNodeValue().trim());
            }
            case 2: {
                return StringUtils.hasText((String)node.getNodeValue()) && ValidationMatcherUtils.isValidationMatcherExpression((String)node.getNodeValue().trim());
            }
        }
        return false;
    }

    protected Class<XmlMessageValidationContext> getRequiredValidationContextType() {
        return XmlMessageValidationContext.class;
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.XML.name()) && MessageUtils.hasXmlPayload((Message)message);
    }

    private NamespaceContextBuilder getNamespaceContextBuilder(TestContext context) {
        if (this.namespaceContextBuilder != null) {
            return this.namespaceContextBuilder;
        }
        return XmlValidationHelper.getNamespaceContextBuilder(context);
    }

    public void setNamespaceContextBuilder(NamespaceContextBuilder namespaceContextBuilder) {
        this.namespaceContextBuilder = namespaceContextBuilder;
    }

    public void validateXMLSchema(Message message, TestContext context, XmlMessageValidationContext xmlMessageValidationContext) {
        this.schemaValidator.validate(message, context, xmlMessageValidationContext);
    }
}

