/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml.xpath;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;

public enum XPathExpressionResult {
    NODE,
    NODESET,
    STRING,
    BOOLEAN,
    NUMBER,
    INTEGER;

    private static final String STRING_PREFIX = "string:";
    private static final String NUMBER_PREFIX = "number:";
    private static final String INTEGER_PREFIX = "integer:";
    private static final String NODE_PREFIX = "node:";
    private static final String NODESET_PREFIX = "node-set:";
    private static final String BOOLEAN_PREFIX = "boolean:";

    public static XPathExpressionResult fromString(String value, XPathExpressionResult defaultResult) {
        if (value.startsWith(STRING_PREFIX)) {
            return STRING;
        }
        if (value.startsWith(NODE_PREFIX)) {
            return NODE;
        }
        if (value.startsWith(NODESET_PREFIX)) {
            return NODESET;
        }
        if (value.startsWith(BOOLEAN_PREFIX)) {
            return BOOLEAN;
        }
        if (value.startsWith(NUMBER_PREFIX)) {
            return NUMBER;
        }
        if (value.startsWith(INTEGER_PREFIX)) {
            return INTEGER;
        }
        return defaultResult;
    }

    public QName getAsQName() {
        if (this.equals((Object)STRING)) {
            return XPathConstants.STRING;
        }
        if (this.equals((Object)NODE)) {
            return XPathConstants.NODE;
        }
        if (this.equals((Object)NODESET)) {
            return XPathConstants.NODESET;
        }
        if (this.equals((Object)BOOLEAN)) {
            return XPathConstants.BOOLEAN;
        }
        if (this.equals((Object)NUMBER) || this.equals((Object)INTEGER)) {
            return XPathConstants.NUMBER;
        }
        return XPathConstants.NODE;
    }

    public static String cutOffPrefix(String expression) {
        if (expression.startsWith(STRING_PREFIX)) {
            return expression.substring(STRING_PREFIX.length());
        }
        if (expression.startsWith(NODE_PREFIX)) {
            return expression.substring(NODE_PREFIX.length());
        }
        if (expression.startsWith(NODESET_PREFIX)) {
            return expression.substring(NODESET_PREFIX.length());
        }
        if (expression.startsWith(BOOLEAN_PREFIX)) {
            return expression.substring(BOOLEAN_PREFIX.length());
        }
        if (expression.startsWith(NUMBER_PREFIX)) {
            return expression.substring(NUMBER_PREFIX.length());
        }
        if (expression.startsWith(INTEGER_PREFIX)) {
            return expression.substring(INTEGER_PREFIX.length());
        }
        return expression;
    }
}

