/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.selector;

import javax.xml.namespace.QName;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageSelector;
import org.citrusframework.message.selector.AbstractMessageSelector;
import org.citrusframework.util.StringUtils;
import org.citrusframework.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.xml.namespace.QNameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;

public class RootQNameMessageSelector
extends AbstractMessageSelector {
    private final QName rootQName;
    public static final String SELECTOR_ID = "root-qname";
    private static final Logger logger = LoggerFactory.getLogger(RootQNameMessageSelector.class);

    public RootQNameMessageSelector(String name, String value, TestContext context) {
        super(name, value, context);
        if (!this.selectKey.equals(SELECTOR_ID)) {
            throw new CitrusRuntimeException(String.format("Invalid usage of root QName message selector - usage restricted to key '%s' but was '%s'", SELECTOR_ID, this.selectKey));
        }
        if (!QNameUtils.validateQName((String)value)) {
            throw new CitrusRuntimeException("Invalid root QName string '" + value + "'");
        }
        this.rootQName = QNameUtils.parseQNameString((String)value);
    }

    public boolean accept(Message message) {
        Document doc;
        try {
            doc = XMLUtils.parseMessagePayload(this.getPayloadAsString(message));
        }
        catch (LSException e) {
            logger.warn("Root QName message selector ignoring not well-formed XML message payload", (Throwable)e);
            return false;
        }
        if (StringUtils.hasText((String)this.rootQName.getNamespaceURI())) {
            return this.rootQName.equals(QNameUtils.getQNameForNode((Node)doc.getFirstChild()));
        }
        return this.rootQName.getLocalPart().equals(doc.getFirstChild().getLocalName());
    }

    public static class Factory
    implements MessageSelector.MessageSelectorFactory {
        public boolean supports(String key) {
            return key.equals(RootQNameMessageSelector.SELECTOR_ID);
        }

        public RootQNameMessageSelector create(String key, String value, TestContext context) {
            return new RootQNameMessageSelector(key, value, context);
        }
    }
}

