/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xhtml;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.spi.Resource;
import org.w3c.tidy.Tidy;

public class XhtmlMessageConverter
implements InitializingPhase {
    private Tidy tidyInstance;
    private Resource tidyConfiguration;
    private static final String W3_XHTML1_URL = "http://www\\.w3\\.org/TR/xhtml1/DTD/";
    private static final String XHTML_DOCTYPE_DEFINITION = "DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0";

    public String convert(String messagePayload) {
        this.initialize();
        if (messagePayload.contains(XHTML_DOCTYPE_DEFINITION)) {
            return messagePayload;
        }
        StringWriter xhtmlWriter = new StringWriter();
        this.tidyInstance.parse((Reader)new StringReader(messagePayload), (Writer)xhtmlWriter);
        String xhtmlPayload = xhtmlWriter.toString();
        xhtmlPayload = xhtmlPayload.replaceFirst(W3_XHTML1_URL, "org/w3/xhtml/");
        return xhtmlPayload;
    }

    public void initialize() {
        if (this.tidyInstance == null) {
            this.tidyInstance = new Tidy();
            this.tidyInstance.setXHTML(true);
            this.tidyInstance.setShowWarnings(false);
            this.tidyInstance.setQuiet(true);
            this.tidyInstance.setEscapeCdata(true);
            this.tidyInstance.setTidyMark(false);
            if (this.tidyConfiguration != null) {
                this.tidyInstance.setConfigurationFromFile(this.tidyConfiguration.getFile().getAbsolutePath());
            }
        }
    }

    public Tidy getTidyInstance() {
        return this.tidyInstance;
    }

    public void setTidyInstance(Tidy tidyInstance) {
        this.tidyInstance = tidyInstance;
    }

    public Resource getTidyConfiguration() {
        return this.tidyConfiguration;
    }

    public void setTidyConfiguration(Resource tidyConfiguration) {
        this.tidyConfiguration = tidyConfiguration;
    }
}

