/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xml;

import java.io.File;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.ObjectHelper;
import org.citrusframework.validation.AbstractValidationProcessor;
import org.citrusframework.validation.GenericValidationProcessor;
import org.citrusframework.xml.StringSource;
import org.citrusframework.xml.Unmarshaller;
import org.w3c.dom.Document;

public abstract class XmlMarshallingValidationProcessor<T>
extends AbstractValidationProcessor<T> {
    private Unmarshaller unmarshaller;

    public XmlMarshallingValidationProcessor() {
    }

    public XmlMarshallingValidationProcessor(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void validate(Message message, TestContext context) {
        this.validate(this.unmarshalMessage(message), message.getHeaders(), context);
    }

    private T unmarshalMessage(Message message) {
        if (this.unmarshaller == null) {
            ObjectHelper.assertNotNull((Object)this.referenceResolver, (String)"Marshalling validation callback requires marshaller instance or proper reference resolver with nested bean definition of type marshaller");
            this.unmarshaller = (Unmarshaller)this.referenceResolver.resolve(Unmarshaller.class);
        }
        try {
            return (T)this.unmarshaller.unmarshal(this.getPayloadSource(message.getPayload()));
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to unmarshal message payload", (Throwable)e);
        }
    }

    private Source getPayloadSource(Object payload) {
        Object source = null;
        if (payload instanceof String) {
            source = new StringSource((String)payload);
        } else if (payload instanceof File) {
            source = new StreamSource((File)payload);
        } else if (payload instanceof Document) {
            source = new DOMSource((Document)payload);
        } else if (payload instanceof Source) {
            source = (Source)payload;
        }
        if (source == null) {
            throw new CitrusRuntimeException("Failed to create payload source for unmarshalling message");
        }
        return source;
    }

    public static final class Builder<T>
    implements MessageProcessor.Builder<XmlMarshallingValidationProcessor<T>, Builder<T>>,
    ReferenceResolverAware {
        private Unmarshaller unmarshaller;
        private final GenericValidationProcessor<T> validationProcessor;
        private ReferenceResolver referenceResolver;

        public Builder(GenericValidationProcessor<T> validationProcessor) {
            this.validationProcessor = validationProcessor;
        }

        public static <T> Builder<T> validate(GenericValidationProcessor<T> validationProcessor) {
            return new Builder<T>(validationProcessor);
        }

        public Builder<T> unmarshaller(Unmarshaller unmarshaller) {
            this.unmarshaller = unmarshaller;
            return this;
        }

        public Builder<T> withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        public XmlMarshallingValidationProcessor<T> build() {
            if (this.unmarshaller == null) {
                if (this.referenceResolver != null) {
                    this.unmarshaller = (Unmarshaller)this.referenceResolver.resolve(Unmarshaller.class);
                } else {
                    throw new CitrusRuntimeException("Missing XML unmarshaller - please set proper unmarshaller or reference resolver");
                }
            }
            if (this.validationProcessor == null) {
                throw new CitrusRuntimeException("Missing validation processor - please add proper validation logic");
            }
            return new XmlMarshallingValidationProcessor<T>(){

                public void validate(T payload, Map<String, Object> headers, TestContext context) {
                    validationProcessor.validate(payload, headers, context);
                }
            };
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }
    }
}

