/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.variable.dictionary.xml;

import java.io.StringWriter;
import org.citrusframework.context.TestContext;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageType;
import org.citrusframework.util.StringUtils;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.validation.xhtml.XhtmlMessageConverter;
import org.citrusframework.variable.dictionary.AbstractDataDictionary;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public abstract class AbstractXmlDataDictionary
extends AbstractDataDictionary<Node> {
    protected void processMessage(Message message, TestContext context) {
        if (message.getPayload() == null || !StringUtils.hasText((String)((String)message.getPayload(String.class)))) {
            return;
        }
        String messagePayload = (String)message.getPayload(String.class);
        if (MessageType.XHTML.name().equalsIgnoreCase(message.getType())) {
            messagePayload = new XhtmlMessageConverter().convert(messagePayload);
        }
        Document doc = XMLUtils.parseMessagePayload(messagePayload);
        LSSerializer serializer = XMLUtils.createLSSerializer();
        serializer.setFilter(new TranslateFilter(context));
        LSOutput output = XMLUtils.createLSOutput();
        String charset = XMLUtils.getTargetCharset(doc).displayName();
        output.setEncoding(charset);
        StringWriter writer = new StringWriter();
        output.setCharacterStream(writer);
        serializer.write(doc, output);
        message.setPayload((Object)writer.toString());
    }

    public boolean supportsMessageType(String messageType) {
        return MessageType.XML.toString().equalsIgnoreCase(messageType) || MessageType.XHTML.toString().equalsIgnoreCase(messageType);
    }

    private class TranslateFilter
    implements LSSerializerFilter {
        private TestContext context;

        public TranslateFilter(TestContext context) {
            this.context = context;
        }

        @Override
        public int getWhatToShow() {
            return -1;
        }

        @Override
        public short acceptNode(Node node) {
            if (node instanceof Element) {
                String translated;
                Element element = (Element)node;
                if (StringUtils.hasText((String)DomUtils.getTextValue((Element)element))) {
                    element.setTextContent((String)AbstractXmlDataDictionary.this.translate(element, DomUtils.getTextValue((Element)element), this.context));
                } else if (!element.hasChildNodes() && StringUtils.hasText((String)(translated = (String)AbstractXmlDataDictionary.this.translate(element, "", this.context)))) {
                    element.appendChild(element.getOwnerDocument().createTextNode(translated));
                }
                NamedNodeMap attributes = element.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attribute = (Attr)attributes.item(i);
                    attribute.setValue((String)AbstractXmlDataDictionary.this.translate(attribute, attribute.getNodeValue(), this.context));
                }
            }
            return 1;
        }
    }
}

