/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.variable.dictionary.xml;

import java.util.Map;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.context.TestContext;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.variable.dictionary.DataDictionary;
import org.citrusframework.variable.dictionary.xml.AbstractXmlDataDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class NodeMappingDataDictionary
extends AbstractXmlDataDictionary
implements InitializingPhase {
    private static final Logger logger = LoggerFactory.getLogger(NodeMappingDataDictionary.class);

    public <T> T translate(Node node, T value, TestContext context) {
        block7: {
            String nodePath;
            block8: {
                block6: {
                    nodePath = XMLUtils.getNodesPathName(node);
                    if (!this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.EXACT)) break block6;
                    if (this.mappings.containsKey(nodePath)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Data dictionary setting element '%s' with value: %s", nodePath, this.mappings.get(nodePath)));
                        }
                        return (T)this.convertIfNecessary((String)this.mappings.get(nodePath), value, context);
                    }
                    break block7;
                }
                if (!this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.ENDS_WITH)) break block8;
                for (Map.Entry entry : this.mappings.entrySet()) {
                    if (!nodePath.endsWith((String)entry.getKey())) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Data dictionary setting element '%s' with value: %s", nodePath, entry.getValue()));
                    }
                    return (T)this.convertIfNecessary((String)entry.getValue(), value, context);
                }
                break block7;
            }
            if (!this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.STARTS_WITH)) break block7;
            for (Map.Entry entry : this.mappings.entrySet()) {
                if (!nodePath.startsWith((String)entry.getKey())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Data dictionary setting element '%s' with value: %s", nodePath, entry.getValue()));
                }
                return (T)this.convertIfNecessary((String)entry.getValue(), value, context);
            }
        }
        return value;
    }
}

