/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ClasspathResourceResolver;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.xml.schema.AbstractSchemaCollection;

public class XsdSchemaCollection
extends AbstractSchemaCollection {
    protected List<String> schemas = new ArrayList<String>();

    @Override
    protected Resource loadSchemaResources() {
        try {
            ClasspathResourceResolver resourceResolver = new ClasspathResourceResolver();
            for (String location : this.schemas) {
                Set findings;
                Resource found = Resources.create((String)location);
                if (found.exists()) {
                    this.schemaResources.add(found);
                    continue;
                }
                if (StringUtils.hasText((String)FileUtils.getFileExtension((String)location))) {
                    String fileNamePattern = FileUtils.getFileName((String)location).replace(".", "\\.").replace("*", ".*");
                    String basePath = FileUtils.getBasePath((String)location);
                    findings = resourceResolver.getResources(basePath, fileNamePattern);
                } else {
                    findings = resourceResolver.getResources(location);
                }
                for (Path finding : findings) {
                    if (!finding.toString().endsWith(".xsd") && !finding.toString().endsWith(".wsdl")) continue;
                    this.schemaResources.add(Resources.fromClasspath((String)finding.toString()));
                }
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read schema collection resources", (Throwable)e);
        }
        return (Resource)this.schemaResources.get(0);
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }
}

