/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml.schema.locator;

import java.net.URI;
import javax.wsdl.xml.WSDLLocator;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class JarWSDLLocator
implements WSDLLocator {
    private static final Logger logger = LoggerFactory.getLogger(JarWSDLLocator.class);
    private final Resource wsdl;
    private Resource importResource = null;

    public JarWSDLLocator(Resource wsdl) {
        this.wsdl = wsdl;
    }

    public InputSource getBaseInputSource() {
        return new InputSource(this.wsdl.getInputStream());
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        URI importURI = URI.create(importLocation);
        Object resolvedImportLocation = importURI.isAbsolute() ? importLocation : parentLocation.substring(0, parentLocation.lastIndexOf(47) + 1) + importLocation;
        this.importResource = Resources.create((String)resolvedImportLocation);
        return new InputSource(this.importResource.getInputStream());
    }

    public String getBaseURI() {
        return this.wsdl.getURI().toString();
    }

    public String getLatestImportURI() {
        if (this.importResource == null) {
            return null;
        }
        return this.importResource.getURI().toString();
    }

    public void close() {
    }
}

