/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.common.Named;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ClasspathResourceResolver;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.xml.schema.TargetNamespaceSchemaMappingStrategy;
import org.citrusframework.xml.schema.WsdlXsdSchema;
import org.citrusframework.xml.schema.XsdSchemaMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.xml.xsd.SimpleXsdSchema;
import org.springframework.xml.xsd.XsdSchema;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XsdSchemaRepository
implements Named,
InitializingPhase {
    private String name = "schemaRepository";
    private List<XsdSchema> schemas = new ArrayList<XsdSchema>();
    private List<String> locations = new ArrayList<String>();
    private XsdSchemaMappingStrategy schemaMappingStrategy = new TargetNamespaceSchemaMappingStrategy();
    private static final Logger logger = LoggerFactory.getLogger(XsdSchemaRepository.class);

    public boolean canValidate(Document doc) {
        XsdSchema schema = this.schemaMappingStrategy.getSchema(this.schemas, doc);
        return schema != null;
    }

    public void initialize() {
        try {
            ClasspathResourceResolver resourceResolver = new ClasspathResourceResolver();
            for (String location : this.locations) {
                Set findings;
                Resource found = Resources.create((String)location);
                if (found.exists()) {
                    this.addSchemas(found);
                    continue;
                }
                if (StringUtils.hasText((String)FileUtils.getFileExtension((String)location))) {
                    String fileNamePattern = FileUtils.getFileName((String)location).replace(".", "\\.").replace("*", ".*");
                    String basePath = FileUtils.getBasePath((String)location);
                    findings = resourceResolver.getResources(basePath, fileNamePattern);
                } else {
                    findings = resourceResolver.getResources(location);
                }
                for (Path resource : findings) {
                    this.addSchemas(Resources.fromClasspath((String)resource.toString()));
                }
            }
            this.addCitrusSchema("citrus-http-message");
            this.addCitrusSchema("citrus-mail-message");
            this.addCitrusSchema("citrus-ftp-message");
            this.addCitrusSchema("citrus-ssh-message");
            this.addCitrusSchema("citrus-rmi-message");
            this.addCitrusSchema("citrus-jmx-message");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CitrusRuntimeException("Failed to initialize Xsd schema repository", (Throwable)e);
        }
    }

    protected void addCitrusSchema(String schemaName) throws IOException, SAXException, ParserConfigurationException {
        Resource resource = Resources.fromClasspath((String)("classpath:org/citrusframework/schema/" + schemaName + ".xsd"));
        if (resource.exists()) {
            this.addXsdSchema(resource);
        }
    }

    private void addSchemas(Resource resource) {
        if (resource.getLocation().endsWith(".xsd")) {
            this.addXsdSchema(resource);
        } else if (resource.getLocation().endsWith(".wsdl")) {
            this.addWsdlSchema(resource);
        } else {
            logger.warn("Skipped resource other than XSD schema for repository (" + resource.getLocation() + ")");
        }
    }

    private void addWsdlSchema(Resource resource) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading WSDL schema resource " + resource.getLocation());
        }
        WsdlXsdSchema wsdl = new WsdlXsdSchema(resource);
        wsdl.initialize();
        this.schemas.add((XsdSchema)wsdl);
    }

    private void addXsdSchema(Resource resource) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading XSD schema resource " + resource.getLocation());
        }
        SimpleXsdSchema schema = new SimpleXsdSchema((org.springframework.core.io.Resource)new ByteArrayResource(FileUtils.copyToByteArray((Resource)resource)));
        try {
            schema.afterPropertiesSet();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CitrusRuntimeException("Failed to initialize xsd schema", (Throwable)e);
        }
        this.schemas.add((XsdSchema)schema);
    }

    public List<XsdSchema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<XsdSchema> schemas) {
        this.schemas = schemas;
    }

    public void setSchemaMappingStrategy(XsdSchemaMappingStrategy schemaMappingStrategy) {
        this.schemaMappingStrategy = schemaMappingStrategy;
    }

    public XsdSchemaMappingStrategy getSchemaMappingStrategy() {
        return this.schemaMappingStrategy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }
}

