/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xml.schema;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.citrusframework.XmlValidationHelper;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.IsXmlPredicate;
import org.citrusframework.util.StringUtils;
import org.citrusframework.util.SystemProvider;
import org.citrusframework.util.XMLUtils;
import org.citrusframework.validation.SchemaValidator;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.citrusframework.validation.xml.schema.ValidationStrategy;
import org.citrusframework.xml.XsdSchemaRepository;
import org.citrusframework.xml.schema.AbstractSchemaCollection;
import org.citrusframework.xml.schema.WsdlXsdSchema;
import org.citrusframework.xml.schema.XsdSchemaCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class XmlSchemaValidation
implements SchemaValidator<XmlMessageValidationContext> {
    public static final String NO_SCHEMA_FOUND_STRATEGY_PROPERTY_NAME = "citrus.xml.no.schema.found.strategy";
    public static final String NO_SCHEMA_FOUND_STRATEGY_ENV_VAR_NAME = "citrus.xml.no.schema.found.strategy".replace(".", "_").toUpperCase();
    private static final Logger logger = LoggerFactory.getLogger(XmlSchemaValidation.class);
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private final ValidationStrategy noSchemaFoundStrategy;

    public XmlSchemaValidation() {
        this(new SystemProvider());
    }

    protected XmlSchemaValidation(SystemProvider systemProvider) {
        this(XmlSchemaValidation.getSchemaValidationStrategy(systemProvider));
    }

    public XmlSchemaValidation(ValidationStrategy noSchemaFoundStrategy) {
        this.noSchemaFoundStrategy = noSchemaFoundStrategy;
    }

    public void validate(Message message, TestContext context, XmlMessageValidationContext validationContext) {
        this.validateSchema(message, context, validationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSchema(Message message, TestContext context, XmlMessageValidationContext validationContext) {
        if (message.getPayload() == null || !StringUtils.hasText((String)((String)message.getPayload(String.class)))) {
            return;
        }
        try {
            SAXParseException[] results;
            Document doc = XMLUtils.parseMessagePayload((String)message.getPayload(String.class));
            if (!StringUtils.hasText((String)doc.getFirstChild().getNamespaceURI())) {
                return;
            }
            logger.debug("Starting XML schema validation ...");
            XmlValidator validator = null;
            XsdSchemaRepository schemaRepository = null;
            List<XsdSchemaRepository> schemaRepositories = XmlValidationHelper.getSchemaRepositories(context);
            if (validationContext.getSchema() != null) {
                validator = ((XsdSchema)context.getReferenceResolver().resolve(validationContext.getSchema(), XsdSchema.class)).createValidator();
            } else if (validationContext.getSchemaRepository() != null) {
                schemaRepository = (XsdSchemaRepository)((Object)context.getReferenceResolver().resolve(validationContext.getSchemaRepository(), XsdSchemaRepository.class));
            } else if (schemaRepositories.size() == 1) {
                schemaRepository = schemaRepositories.get(0);
            } else if (!schemaRepositories.isEmpty()) {
                schemaRepository = schemaRepositories.stream().filter(repository -> repository.canValidate(doc)).findFirst().orElseThrow(() -> new CitrusRuntimeException(String.format("Failed to find proper schema repository for validating element '%s(%s)'", doc.getFirstChild().getLocalName(), doc.getFirstChild().getNamespaceURI())));
            } else {
                logger.warn("Neither schema instance nor schema repository defined - skipping XML schema validation");
                return;
            }
            if (schemaRepository != null) {
                if (!schemaRepository.canValidate(doc)) {
                    if (ValidationStrategy.FAIL.equals((Object)this.noSchemaFoundStrategy)) {
                        throw new CitrusRuntimeException(String.format("Unable to find proper XML schema definition for element '%s(%s)' in schema repository '%s'", doc.getFirstChild().getLocalName(), doc.getFirstChild().getNamespaceURI(), schemaRepository.getName()));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace(this.createSchemaNotFoundMessage(doc, schemaRepository));
                    }
                    return;
                }
                ArrayList<Resource> schemas = new ArrayList<Resource>();
                for (XsdSchema xsdSchema : schemaRepository.getSchemas()) {
                    if (xsdSchema instanceof XsdSchemaCollection) {
                        XsdSchemaCollection xsdSchemaCollection = (XsdSchemaCollection)xsdSchema;
                        schemas.addAll(xsdSchemaCollection.getSchemaResources());
                        continue;
                    }
                    if (xsdSchema instanceof WsdlXsdSchema) {
                        WsdlXsdSchema wsdlXsdSchema = (WsdlXsdSchema)xsdSchema;
                        schemas.addAll(wsdlXsdSchema.getSchemaResources());
                        continue;
                    }
                    TransformerFactory transformerFactory = this.transformerFactory;
                    synchronized (transformerFactory) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        try {
                            this.transformerFactory.newTransformer().transform(xsdSchema.getSource(), new StreamResult(bos));
                        }
                        catch (TransformerException e) {
                            throw new CitrusRuntimeException("Failed to read schema " + xsdSchema.getTargetNamespace(), (Throwable)e);
                        }
                        schemas.add(Resources.create((byte[])bos.toByteArray()));
                    }
                }
                validator = XmlValidatorFactory.createValidator((org.springframework.core.io.Resource[])schemas.stream().map(AbstractSchemaCollection::toSpringResource).toList().toArray(new org.springframework.core.io.Resource[0]), (String)"http://www.w3.org/2001/XMLSchema");
            }
            if ((results = validator.validate((Source)new DOMSource(doc))).length != 0) {
                if (logger.isErrorEnabled()) {
                    logger.error("XML schema validation failed for message:\n{}", (Object)XMLUtils.prettyPrint((String)message.getPayload(String.class)));
                }
                logger.debug("Found {} schema validation errors", (Object)results.length);
                StringBuilder errors = new StringBuilder();
                for (SAXParseException e : results) {
                    errors.append(e.toString());
                    errors.append("\n");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(errors.toString());
                }
                throw new ValidationException("XML schema validation failed:", (Throwable)results[0]);
            }
            logger.debug("XML schema validation successful: All values OK");
        }
        catch (IOException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return "XML".equals(messageType) || message != null && IsXmlPredicate.getInstance().test((String)message.getPayload(String.class));
    }

    private String createSchemaNotFoundMessage(Document doc, XsdSchemaRepository schemaRepository) {
        return String.format("Unable to find proper XML schema definition for element '%s(%s)' in schema repository '%s'", doc.getFirstChild().getLocalName(), doc.getFirstChild().getNamespaceURI(), schemaRepository.getName());
    }

    private static ValidationStrategy getSchemaValidationStrategy(SystemProvider systemProvider) {
        return XmlSchemaValidation.extractEnvOrProperty(systemProvider, NO_SCHEMA_FOUND_STRATEGY_ENV_VAR_NAME, NO_SCHEMA_FOUND_STRATEGY_PROPERTY_NAME).map(String::toUpperCase).map(value -> {
            try {
                return ValidationStrategy.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new CitrusRuntimeException(String.format("Invalid property value '%s' for no schema found strategy", value));
            }
        }).orElse(ValidationStrategy.FAIL);
    }

    private static Optional<String> extractEnvOrProperty(SystemProvider systemProvider, String envVarName, String fallbackPropertyName) {
        return systemProvider.getEnv(envVarName).or(() -> systemProvider.getProperty(fallbackPropertyName));
    }

    public boolean canValidate(Message message, boolean schemaValidationEnabled) {
        return (XmlSchemaValidation.isXmlSchemaValidationEnabled() || schemaValidationEnabled) && IsXmlPredicate.getInstance().test((String)message.getPayload(String.class));
    }

    private static boolean isXmlSchemaValidationEnabled() {
        return Boolean.getBoolean("citrus.validation.outbound.schema.enabled") || Boolean.getBoolean("citrus.validation.outbound.xml.schema.enabled") || Boolean.parseBoolean(System.getenv("CITRUS_VALIDATION_OUTBOUND_SCHEMA_ENABLED")) || Boolean.parseBoolean(System.getenv("CITRUS_VALIDATION_OUTBOUND_XML_SCHEMA_ENABLED"));
    }

    public void validate(Message message, TestContext context, String schemaRepository, String schema) {
        XmlMessageValidationContext validationContext = ((XmlMessageValidationContext.Builder)((XmlMessageValidationContext.Builder)((XmlMessageValidationContext.Builder)XmlMessageValidationContext.Builder.xml().schemaValidation(true)).schema(schema)).schemaRepository(schemaRepository)).build();
        this.validate(message, context, validationContext);
    }
}

