/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.repository.BaseRepository;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.citrusframework.xml.schema.TargetNamespaceSchemaMappingStrategy;
import org.citrusframework.xml.schema.WsdlXsdSchema;
import org.citrusframework.xml.schema.XsdSchemaMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.xml.xsd.SimpleXsdSchema;
import org.springframework.xml.xsd.XsdSchema;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XsdSchemaRepository
extends BaseRepository {
    private static final String DEFAULT_NAME = "schemaRepository";
    private List<XsdSchema> schemas = new ArrayList<XsdSchema>();
    private XsdSchemaMappingStrategy schemaMappingStrategy = new TargetNamespaceSchemaMappingStrategy();
    private static final Logger logger = LoggerFactory.getLogger(XsdSchemaRepository.class);

    public XsdSchemaRepository() {
        super(DEFAULT_NAME);
    }

    public boolean canValidate(Document doc) {
        XsdSchema schema = this.schemaMappingStrategy.getSchema(this.schemas, doc);
        return schema != null;
    }

    public void initialize() {
        super.initialize();
        try {
            this.addCitrusSchema("citrus-http-message");
            this.addCitrusSchema("citrus-mail-message");
            this.addCitrusSchema("citrus-ftp-message");
            this.addCitrusSchema("citrus-ssh-message");
            this.addCitrusSchema("citrus-rmi-message");
            this.addCitrusSchema("citrus-jmx-message");
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new CitrusRuntimeException("Failed to initialize Xsd schema repository", (Throwable)e);
        }
    }

    protected void addCitrusSchema(String schemaName) throws SAXException, ParserConfigurationException {
        Resource resource = Resources.fromClasspath((String)("classpath:org/citrusframework/schema/" + schemaName + ".xsd"));
        if (resource.exists()) {
            this.addXsdSchema(resource);
        }
    }

    protected void addRepository(Resource resource) {
        if (resource.getLocation().endsWith(".xsd")) {
            this.addXsdSchema(resource);
        } else if (resource.getLocation().endsWith(".wsdl")) {
            this.addWsdlSchema(resource);
        } else {
            logger.warn("Skipped resource other than XSD schema for repository '{}'", (Object)resource.getLocation());
        }
    }

    private void addWsdlSchema(Resource resource) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading WSDL schema resource '{}'", (Object)resource.getLocation());
        }
        WsdlXsdSchema wsdl = new WsdlXsdSchema(resource);
        wsdl.initialize();
        this.schemas.add((XsdSchema)wsdl);
    }

    private void addXsdSchema(Resource resource) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading XSD schema resource '{}'", (Object)resource.getLocation());
        }
        SimpleXsdSchema schema = new SimpleXsdSchema((org.springframework.core.io.Resource)new ByteArrayResource(FileUtils.copyToByteArray((Resource)resource)));
        try {
            schema.afterPropertiesSet();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CitrusRuntimeException("Failed to initialize xsd schema", (Throwable)e);
        }
        this.schemas.add((XsdSchema)schema);
    }

    public List<XsdSchema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<XsdSchema> schemas) {
        this.schemas = schemas;
    }

    public void setSchemaMappingStrategy(XsdSchemaMappingStrategy schemaMappingStrategy) {
        this.schemaMappingStrategy = schemaMappingStrategy;
    }

    public XsdSchemaMappingStrategy getSchemaMappingStrategy() {
        return this.schemaMappingStrategy;
    }
}

