/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml.schema.locator;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.wsdl.xml.WSDLLocator;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.xml.sax.InputSource;

public class JarWSDLLocator
implements WSDLLocator {
    private final Resource wsdl;
    private Resource importResource = null;

    public JarWSDLLocator(Resource wsdl) {
        this.wsdl = wsdl;
    }

    public InputSource getBaseInputSource() {
        return new InputSource(this.wsdl.getInputStream());
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        Object resolvedImportLocation;
        String decodedImportLocation = URLDecoder.decode(importLocation, StandardCharsets.UTF_8);
        URI importURI = URI.create(decodedImportLocation);
        if (importURI.isAbsolute()) {
            resolvedImportLocation = decodedImportLocation;
        } else {
            String decodedParentLocation = URLDecoder.decode(parentLocation, StandardCharsets.UTF_8);
            resolvedImportLocation = decodedParentLocation.substring(0, decodedParentLocation.lastIndexOf(47) + 1) + decodedImportLocation;
        }
        this.importResource = Resources.create((String)resolvedImportLocation);
        return new InputSource(this.importResource.getInputStream());
    }

    public String getBaseURI() {
        return URLDecoder.decode(this.wsdl.getURI().toString(), StandardCharsets.UTF_8);
    }

    public String getLatestImportURI() {
        if (this.importResource == null) {
            return null;
        }
        return this.importResource.getURI().toString();
    }

    public void close() {
    }
}

