/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.websocket.client;

import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.websocket.client.WebSocketClient;
import org.citrusframework.websocket.message.WebSocketMessageConverter;

public class WebSocketClientBuilder
extends AbstractEndpointBuilder<WebSocketClient> {
    private WebSocketClient endpoint = new WebSocketClient();

    protected WebSocketClient getEndpoint() {
        return this.endpoint;
    }

    public WebSocketClientBuilder requestUrl(String requestUrl) {
        this.endpoint.getEndpointConfiguration().setEndpointUri(requestUrl);
        return this;
    }

    public WebSocketClientBuilder messageConverter(WebSocketMessageConverter messageConverter) {
        this.endpoint.getEndpointConfiguration().setMessageConverter(messageConverter);
        return this;
    }

    public WebSocketClientBuilder endpointResolver(EndpointUriResolver resolver) {
        this.endpoint.getEndpointConfiguration().setEndpointUriResolver(resolver);
        return this;
    }

    public WebSocketClientBuilder pollingInterval(int pollingInterval) {
        this.endpoint.getEndpointConfiguration().setPollingInterval(pollingInterval);
        return this;
    }

    public WebSocketClientBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }
}

