/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.websocket.client;

import jakarta.websocket.Extension;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.websocket.endpoint.AbstractWebSocketEndpointConfiguration;
import org.citrusframework.websocket.handler.CitrusWebSocketHandler;
import org.eclipse.jetty.ee10.websocket.jakarta.common.JakartaWebSocketExtension;
import org.eclipse.jetty.websocket.core.internal.PerMessageDeflateExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.adapter.standard.StandardToWebSocketExtensionAdapter;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.util.UriComponentsBuilder;

public class WebSocketClientEndpointConfiguration
extends AbstractWebSocketEndpointConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketClientEndpointConfiguration.class);
    private CitrusWebSocketHandler handler;
    private WebSocketClient client = new StandardWebSocketClient();
    private WebSocketHttpHeaders webSocketHttpHeaders;

    @Override
    public CitrusWebSocketHandler getHandler() {
        if (this.handler == null) {
            this.handler = this.getWebSocketClientHandler(this.getEndpointUri());
        }
        return this.handler;
    }

    @Override
    public void setHandler(CitrusWebSocketHandler handler) {
        throw new UnsupportedOperationException("Not allowed to set web socket handler directly!");
    }

    private CitrusWebSocketHandler getWebSocketClientHandler(String url) {
        CitrusWebSocketHandler handler = new CitrusWebSocketHandler();
        if (this.webSocketHttpHeaders == null) {
            this.webSocketHttpHeaders = new WebSocketHttpHeaders();
            try (PerMessageDeflateExtension perMessageDeflateExtension = new PerMessageDeflateExtension();){
                this.webSocketHttpHeaders.setSecWebSocketExtensions(Collections.singletonList(new StandardToWebSocketExtensionAdapter((Extension)new JakartaWebSocketExtension(perMessageDeflateExtension.getName()))));
            }
        }
        CompletableFuture future = this.client.execute((WebSocketHandler)handler, this.webSocketHttpHeaders, UriComponentsBuilder.fromUriString((String)url).buildAndExpand(new Object[0]).encode().toUri());
        try {
            future.get();
        }
        catch (Exception e) {
            String errMsg = String.format("Failed to connect to Web Socket server - '%s'", url);
            logger.error(errMsg);
            throw new CitrusRuntimeException(errMsg);
        }
        return handler;
    }

    public void setClient(WebSocketClient client) {
        this.client = client;
    }

    public WebSocketHttpHeaders getWebSocketHttpHeaders() {
        return this.webSocketHttpHeaders;
    }

    public void setWebSocketHttpHeaders(WebSocketHttpHeaders webSocketHttpHeaders) {
        this.webSocketHttpHeaders = webSocketHttpHeaders;
    }
}

