/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.websocket.config.annotation;

import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;
import org.citrusframework.websocket.client.WebSocketClient;
import org.citrusframework.websocket.client.WebSocketClientBuilder;
import org.citrusframework.websocket.config.annotation.WebSocketClientConfig;
import org.citrusframework.websocket.message.WebSocketMessageConverter;

public class WebSocketClientConfigParser
implements AnnotationConfigParser<WebSocketClientConfig, WebSocketClient> {
    public WebSocketClient parse(WebSocketClientConfig annotation, ReferenceResolver referenceResolver) {
        WebSocketClientBuilder builder = new WebSocketClientBuilder();
        builder.requestUrl(annotation.requestUrl());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((WebSocketMessageConverter)referenceResolver.resolve(annotation.messageConverter(), WebSocketMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.endpointResolver())) {
            builder.endpointResolver((EndpointUriResolver)referenceResolver.resolve(annotation.endpointResolver(), EndpointUriResolver.class));
        }
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (WebSocketClient)builder.initialize().build();
    }
}

