/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.websocket.config.annotation;

import java.util.ArrayList;
import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.http.message.HttpMessageConverter;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;
import org.citrusframework.websocket.config.annotation.WebSocketConfig;
import org.citrusframework.websocket.config.annotation.WebSocketServerConfig;
import org.citrusframework.websocket.endpoint.WebSocketEndpoint;
import org.citrusframework.websocket.message.WebSocketMessageConverter;
import org.citrusframework.websocket.server.WebSocketServer;
import org.citrusframework.websocket.server.WebSocketServerBuilder;
import org.citrusframework.websocket.server.WebSocketServerEndpointConfiguration;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.springframework.web.servlet.HandlerInterceptor;

public class WebSocketServerConfigParser
implements AnnotationConfigParser<WebSocketServerConfig, WebSocketServer> {
    public WebSocketServer parse(WebSocketServerConfig annotation, ReferenceResolver referenceResolver) {
        WebSocketConfig[] webSocketConfigs;
        WebSocketServerBuilder builder = new WebSocketServerBuilder();
        ArrayList<WebSocketEndpoint> webSockets = new ArrayList<WebSocketEndpoint>();
        for (WebSocketConfig webSocketConfig : webSocketConfigs = annotation.webSockets()) {
            WebSocketServerEndpointConfiguration webSocketConfiguration = new WebSocketServerEndpointConfiguration();
            webSocketConfiguration.setEndpointUri(webSocketConfig.path());
            if (StringUtils.hasText((String)webSocketConfig.messageConverter())) {
                webSocketConfiguration.setMessageConverter((WebSocketMessageConverter)referenceResolver.resolve(webSocketConfig.messageConverter(), WebSocketMessageConverter.class));
            }
            webSocketConfiguration.setTimeout(webSocketConfig.timeout());
            WebSocketEndpoint webSocket = new WebSocketEndpoint(webSocketConfiguration);
            webSocket.setName(webSocketConfig.id());
            webSockets.add(webSocket);
        }
        builder.webSockets(webSockets);
        builder.autoStart(annotation.autoStart());
        builder.timeout(annotation.timeout());
        builder.debugLogging(annotation.debugLogging());
        if (StringUtils.hasText((String)annotation.endpointAdapter())) {
            builder.endpointAdapter((EndpointAdapter)referenceResolver.resolve(annotation.endpointAdapter(), EndpointAdapter.class));
        }
        builder.interceptors(referenceResolver.resolve(annotation.interceptors(), HandlerInterceptor.class));
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        builder.port(annotation.port());
        if (StringUtils.hasText((String)annotation.contextConfigLocation())) {
            builder.contextConfigLocation(annotation.contextConfigLocation());
        }
        if (StringUtils.hasText((String)annotation.resourceBase())) {
            builder.resourceBase(annotation.resourceBase());
        }
        builder.rootParentContext(annotation.rootParentContext());
        builder.connectors(referenceResolver.resolve(annotation.connectors(), Connector.class));
        if (StringUtils.hasText((String)annotation.connector())) {
            builder.connector((Connector)referenceResolver.resolve(annotation.connector(), Connector.class));
        }
        if (StringUtils.hasText((String)annotation.servletName())) {
            builder.servletName(annotation.servletName());
        }
        if (StringUtils.hasText((String)annotation.servletMappingPath())) {
            builder.servletMappingPath(annotation.servletMappingPath());
        }
        if (StringUtils.hasText((String)annotation.contextPath())) {
            builder.contextPath(annotation.contextPath());
        }
        if (StringUtils.hasText((String)annotation.servletHandler())) {
            builder.servletHandler((ServletHandler)referenceResolver.resolve(annotation.servletHandler(), ServletHandler.class));
        }
        if (StringUtils.hasText((String)annotation.securityHandler())) {
            builder.securityHandler((SecurityHandler)referenceResolver.resolve(annotation.securityHandler(), SecurityHandler.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((HttpMessageConverter)referenceResolver.resolve(annotation.messageConverter(), HttpMessageConverter.class));
        }
        builder.initialize();
        return (WebSocketServer)builder.build();
    }
}

