/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.websocket.config.xml;

import java.util.List;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.config.xml.HttpServerParser;
import org.citrusframework.server.AbstractServer;
import org.citrusframework.websocket.server.WebSocketServer;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class WebSocketServerParser
extends HttpServerParser {
    protected void parseServer(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        super.parseServer(builder, element, parserContext);
        ManagedList webSocketReferences = new ManagedList();
        Element socketsElement = DomUtils.getChildElementByTagName((Element)element, (String)"endpoints");
        if (socketsElement != null) {
            List socketElements = DomUtils.getChildElements((Element)socketsElement);
            if (socketElements.isEmpty()) {
                throw new CitrusRuntimeException("Invalid '<endpoints>..</endpoints>' configuration - at least one '<endpoint ref=\"..\" />' must be defined");
            }
            for (Element socketElement : socketElements) {
                if (!socketElement.hasAttribute("ref")) continue;
                webSocketReferences.add((Object)new RuntimeBeanReference(socketElement.getAttribute("ref")));
            }
            if (webSocketReferences.size() > 0) {
                builder.addPropertyValue("webSockets", (Object)webSocketReferences);
            }
        }
    }

    protected Class<? extends AbstractServer> getServerClass() {
        return WebSocketServer.class;
    }
}

