/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.websocket.endpoint;

import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.exceptions.MessageTimeoutException;
import org.citrusframework.message.Message;
import org.citrusframework.messaging.AbstractSelectiveMessageConsumer;
import org.citrusframework.websocket.endpoint.WebSocketEndpointConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketMessage;

public class WebSocketConsumer
extends AbstractSelectiveMessageConsumer {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketConsumer.class);
    private final WebSocketEndpointConfiguration endpointConfiguration;

    public WebSocketConsumer(String name, WebSocketEndpointConfiguration endpointConfiguration) {
        super(name, (EndpointConfiguration)endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
    }

    public Message receive(String selector, TestContext context, long timeout) {
        logger.info(String.format("Waiting %s ms for Web Socket message ...", timeout));
        WebSocketMessage<?> message = this.receive(this.endpointConfiguration, timeout);
        Message receivedMessage = this.endpointConfiguration.getMessageConverter().convertInbound(message, this.endpointConfiguration, context);
        logger.info("Received Web Socket message");
        context.onInboundMessage(receivedMessage);
        return receivedMessage;
    }

    private WebSocketMessage<?> receive(WebSocketEndpointConfiguration config, long timeout) {
        long timeLeft = timeout;
        WebSocketMessage<?> message = config.getHandler().getMessage();
        String endpointUri = this.endpointConfiguration.getEndpointUri();
        while (message == null && timeLeft > 0L) {
            long sleep;
            long l = sleep = (timeLeft -= this.endpointConfiguration.getPollingInterval()) > 0L ? this.endpointConfiguration.getPollingInterval() : this.endpointConfiguration.getPollingInterval() + timeLeft;
            if (logger.isDebugEnabled()) {
                String msg = "Waiting for message on '%s' - retrying in %s ms";
                logger.debug(String.format(msg, endpointUri, sleep));
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                logger.warn(String.format("Thread interrupted while waiting for message on '%s'", endpointUri), (Throwable)e);
            }
            message = config.getHandler().getMessage();
        }
        if (message == null) {
            throw new MessageTimeoutException(timeout, endpointUri);
        }
        return message;
    }
}

