/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.websocket.endpoint;

import org.citrusframework.endpoint.AbstractEndpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.messaging.Producer;
import org.citrusframework.messaging.SelectiveConsumer;
import org.citrusframework.websocket.endpoint.WebSocketConsumer;
import org.citrusframework.websocket.endpoint.WebSocketEndpointConfiguration;
import org.citrusframework.websocket.endpoint.WebSocketProducer;
import org.citrusframework.websocket.handler.CitrusWebSocketHandler;

public class WebSocketEndpoint
extends AbstractEndpoint {
    private WebSocketProducer wsProducer;
    private WebSocketConsumer wsConsumer;

    public WebSocketEndpoint(WebSocketEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
    }

    public SelectiveConsumer createConsumer() {
        if (this.wsConsumer == null) {
            this.wsConsumer = new WebSocketConsumer(this.getConsumerName(), this.getEndpointConfiguration());
        }
        return this.wsConsumer;
    }

    public Producer createProducer() {
        if (this.wsProducer == null) {
            this.wsProducer = new WebSocketProducer(this.getProducerName(), this.getEndpointConfiguration());
        }
        return this.wsProducer;
    }

    public WebSocketEndpointConfiguration getEndpointConfiguration() {
        return (WebSocketEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void setWebSocketHandler(CitrusWebSocketHandler handler) {
        this.getEndpointConfiguration().setHandler(handler);
    }
}

