/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.websocket.endpoint;

import org.citrusframework.context.TestContext;
import org.citrusframework.message.Message;
import org.citrusframework.messaging.Producer;
import org.citrusframework.util.ObjectHelper;
import org.citrusframework.websocket.endpoint.WebSocketEndpointConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketMessage;

public class WebSocketProducer
implements Producer {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketProducer.class);
    private final String name;
    private final WebSocketEndpointConfiguration endpointConfiguration;

    public WebSocketProducer(String name, WebSocketEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
    }

    public void send(Message message, TestContext context) {
        ObjectHelper.assertNotNull((Object)message, (String)"Message is empty - unable to send empty message");
        logger.info("Sending WebSocket message ...");
        context.onOutboundMessage(message);
        WebSocketMessage wsMessage = this.endpointConfiguration.getMessageConverter().convertOutbound(message, this.endpointConfiguration, context);
        if (this.endpointConfiguration.getHandler().sendMessage(wsMessage)) {
            logger.info("WebSocket Message was successfully sent");
        }
    }

    public String getName() {
        return this.name;
    }
}

