/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.websocket.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

public class CitrusWebSocketHandler
extends AbstractWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(CitrusWebSocketHandler.class);
    private final Queue<WebSocketMessage<?>> inboundMessages = new LinkedList();
    private final Map<String, WebSocketSession> sessions = new HashMap<String, WebSocketSession>();

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        logger.debug(String.format("WebSocket connection established (%s)", session.getId()));
        this.sessions.put(session.getId(), session);
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        logger.debug(String.format("WebSocket endpoint (%s) received text message", session.getId()));
        this.inboundMessages.add((WebSocketMessage<?>)message);
    }

    protected void handleBinaryMessage(WebSocketSession session, BinaryMessage message) throws Exception {
        logger.debug(String.format("WebSocket endpoint (%s) received binary message", session.getId()));
        this.inboundMessages.add((WebSocketMessage<?>)message);
    }

    protected void handlePongMessage(WebSocketSession session, PongMessage message) throws Exception {
        logger.debug(String.format("WebSocket endpoint (%s) received pong message", session.getId()));
        this.inboundMessages.add((WebSocketMessage<?>)message);
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        logger.error(String.format("WebSocket transport error (%s)", session.getId()), exception);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        logger.debug(String.format("WebSocket session (%s) closed - status : %s", session.getId(), status));
        this.sessions.remove(session.getId());
    }

    public WebSocketMessage<?> getMessage() {
        return this.inboundMessages.poll();
    }

    public boolean sendMessage(WebSocketMessage<?> message) {
        boolean sentSuccessfully = false;
        if (this.sessions.isEmpty()) {
            logger.warn("No Web Socket session exists - message cannot be sent");
        }
        for (WebSocketSession session : this.sessions.values()) {
            if (session == null || !session.isOpen()) continue;
            try {
                session.sendMessage(message);
                sentSuccessfully = true;
            }
            catch (IOException e) {
                logger.error(String.format("(%s) error sending message", session.getId()), (Throwable)e);
            }
        }
        return sentSuccessfully;
    }
}

